package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait BurnInBackgroundColor {
  def unwrap
      : software.amazon.awssdk.services.medialive.model.BurnInBackgroundColor
}
object BurnInBackgroundColor {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.BurnInBackgroundColor
  ): zio.aws.medialive.model.BurnInBackgroundColor = value match {
    case software.amazon.awssdk.services.medialive.model.BurnInBackgroundColor.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.BurnInBackgroundColor.BLACK =>
      val r = BLACK
      r
    case software.amazon.awssdk.services.medialive.model.BurnInBackgroundColor.NONE =>
      val r = NONE
      r
    case software.amazon.awssdk.services.medialive.model.BurnInBackgroundColor.WHITE =>
      val r = WHITE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.BurnInBackgroundColor {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.BurnInBackgroundColor =
      software.amazon.awssdk.services.medialive.model.BurnInBackgroundColor.UNKNOWN_TO_SDK_VERSION
  }
  case object BLACK extends zio.aws.medialive.model.BurnInBackgroundColor {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.BurnInBackgroundColor =
      software.amazon.awssdk.services.medialive.model.BurnInBackgroundColor.BLACK
  }
  case object NONE extends zio.aws.medialive.model.BurnInBackgroundColor {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.BurnInBackgroundColor =
      software.amazon.awssdk.services.medialive.model.BurnInBackgroundColor.NONE
  }
  case object WHITE extends zio.aws.medialive.model.BurnInBackgroundColor {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.BurnInBackgroundColor =
      software.amazon.awssdk.services.medialive.model.BurnInBackgroundColor.WHITE
  }
}
