package zio.aws.medialive.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.{
  __integerMin0,
  __string,
  __integer,
  __integerMin0Max10,
  __integerMin0Max255,
  __integerMin96Max600
}
import scala.jdk.CollectionConverters._
final case class BurnInDestinationSettings(
    alignment: Option[zio.aws.medialive.model.BurnInAlignment] = None,
    backgroundColor: Option[zio.aws.medialive.model.BurnInBackgroundColor] =
      None,
    backgroundOpacity: Option[__integerMin0Max255] = None,
    font: Option[zio.aws.medialive.model.InputLocation] = None,
    fontColor: Option[zio.aws.medialive.model.BurnInFontColor] = None,
    fontOpacity: Option[__integerMin0Max255] = None,
    fontResolution: Option[__integerMin96Max600] = None,
    fontSize: Option[__string] = None,
    outlineColor: Option[zio.aws.medialive.model.BurnInOutlineColor] = None,
    outlineSize: Option[__integerMin0Max10] = None,
    shadowColor: Option[zio.aws.medialive.model.BurnInShadowColor] = None,
    shadowOpacity: Option[__integerMin0Max255] = None,
    shadowXOffset: Option[__integer] = None,
    shadowYOffset: Option[__integer] = None,
    teletextGridControl: Option[
      zio.aws.medialive.model.BurnInTeletextGridControl
    ] = None,
    xPosition: Option[__integerMin0] = None,
    yPosition: Option[__integerMin0] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.BurnInDestinationSettings = {
    import BurnInDestinationSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.BurnInDestinationSettings
      .builder()
      .optionallyWith(alignment.map(value => value.unwrap))(_.alignment)
      .optionallyWith(backgroundColor.map(value => value.unwrap))(
        _.backgroundColor
      )
      .optionallyWith(backgroundOpacity.map(value => value: Integer))(
        _.backgroundOpacity
      )
      .optionallyWith(font.map(value => value.buildAwsValue()))(_.font)
      .optionallyWith(fontColor.map(value => value.unwrap))(_.fontColor)
      .optionallyWith(fontOpacity.map(value => value: Integer))(_.fontOpacity)
      .optionallyWith(fontResolution.map(value => value: Integer))(
        _.fontResolution
      )
      .optionallyWith(fontSize.map(value => value: java.lang.String))(
        _.fontSize
      )
      .optionallyWith(outlineColor.map(value => value.unwrap))(_.outlineColor)
      .optionallyWith(outlineSize.map(value => value: Integer))(_.outlineSize)
      .optionallyWith(shadowColor.map(value => value.unwrap))(_.shadowColor)
      .optionallyWith(shadowOpacity.map(value => value: Integer))(
        _.shadowOpacity
      )
      .optionallyWith(shadowXOffset.map(value => value: Integer))(
        _.shadowXOffset
      )
      .optionallyWith(shadowYOffset.map(value => value: Integer))(
        _.shadowYOffset
      )
      .optionallyWith(teletextGridControl.map(value => value.unwrap))(
        _.teletextGridControl
      )
      .optionallyWith(xPosition.map(value => value: Integer))(_.xPosition)
      .optionallyWith(yPosition.map(value => value: Integer))(_.yPosition)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.BurnInDestinationSettings.ReadOnly =
    zio.aws.medialive.model.BurnInDestinationSettings.wrap(buildAwsValue())
}
object BurnInDestinationSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.BurnInDestinationSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.BurnInDestinationSettings =
      zio.aws.medialive.model.BurnInDestinationSettings(
        alignment.map(value => value),
        backgroundColor.map(value => value),
        backgroundOpacity.map(value => value),
        font.map(value => value.asEditable),
        fontColor.map(value => value),
        fontOpacity.map(value => value),
        fontResolution.map(value => value),
        fontSize.map(value => value),
        outlineColor.map(value => value),
        outlineSize.map(value => value),
        shadowColor.map(value => value),
        shadowOpacity.map(value => value),
        shadowXOffset.map(value => value),
        shadowYOffset.map(value => value),
        teletextGridControl.map(value => value),
        xPosition.map(value => value),
        yPosition.map(value => value)
      )
    def alignment: Option[zio.aws.medialive.model.BurnInAlignment]
    def backgroundColor: Option[zio.aws.medialive.model.BurnInBackgroundColor]
    def backgroundOpacity: Option[__integerMin0Max255]
    def font: Option[zio.aws.medialive.model.InputLocation.ReadOnly]
    def fontColor: Option[zio.aws.medialive.model.BurnInFontColor]
    def fontOpacity: Option[__integerMin0Max255]
    def fontResolution: Option[__integerMin96Max600]
    def fontSize: Option[__string]
    def outlineColor: Option[zio.aws.medialive.model.BurnInOutlineColor]
    def outlineSize: Option[__integerMin0Max10]
    def shadowColor: Option[zio.aws.medialive.model.BurnInShadowColor]
    def shadowOpacity: Option[__integerMin0Max255]
    def shadowXOffset: Option[__integer]
    def shadowYOffset: Option[__integer]
    def teletextGridControl
        : Option[zio.aws.medialive.model.BurnInTeletextGridControl]
    def xPosition: Option[__integerMin0]
    def yPosition: Option[__integerMin0]
    def getAlignment
        : ZIO[Any, AwsError, zio.aws.medialive.model.BurnInAlignment] =
      AwsError.unwrapOptionField("alignment", alignment)
    def getBackgroundColor
        : ZIO[Any, AwsError, zio.aws.medialive.model.BurnInBackgroundColor] =
      AwsError.unwrapOptionField("backgroundColor", backgroundColor)
    def getBackgroundOpacity: ZIO[Any, AwsError, __integerMin0Max255] =
      AwsError.unwrapOptionField("backgroundOpacity", backgroundOpacity)
    def getFont
        : ZIO[Any, AwsError, zio.aws.medialive.model.InputLocation.ReadOnly] =
      AwsError.unwrapOptionField("font", font)
    def getFontColor
        : ZIO[Any, AwsError, zio.aws.medialive.model.BurnInFontColor] =
      AwsError.unwrapOptionField("fontColor", fontColor)
    def getFontOpacity: ZIO[Any, AwsError, __integerMin0Max255] =
      AwsError.unwrapOptionField("fontOpacity", fontOpacity)
    def getFontResolution: ZIO[Any, AwsError, __integerMin96Max600] =
      AwsError.unwrapOptionField("fontResolution", fontResolution)
    def getFontSize: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("fontSize", fontSize)
    def getOutlineColor
        : ZIO[Any, AwsError, zio.aws.medialive.model.BurnInOutlineColor] =
      AwsError.unwrapOptionField("outlineColor", outlineColor)
    def getOutlineSize: ZIO[Any, AwsError, __integerMin0Max10] =
      AwsError.unwrapOptionField("outlineSize", outlineSize)
    def getShadowColor
        : ZIO[Any, AwsError, zio.aws.medialive.model.BurnInShadowColor] =
      AwsError.unwrapOptionField("shadowColor", shadowColor)
    def getShadowOpacity: ZIO[Any, AwsError, __integerMin0Max255] =
      AwsError.unwrapOptionField("shadowOpacity", shadowOpacity)
    def getShadowXOffset: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("shadowXOffset", shadowXOffset)
    def getShadowYOffset: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("shadowYOffset", shadowYOffset)
    def getTeletextGridControl: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.BurnInTeletextGridControl
    ] = AwsError.unwrapOptionField("teletextGridControl", teletextGridControl)
    def getXPosition: ZIO[Any, AwsError, __integerMin0] =
      AwsError.unwrapOptionField("xPosition", xPosition)
    def getYPosition: ZIO[Any, AwsError, __integerMin0] =
      AwsError.unwrapOptionField("yPosition", yPosition)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.BurnInDestinationSettings
  ) extends zio.aws.medialive.model.BurnInDestinationSettings.ReadOnly {
    override val alignment: Option[zio.aws.medialive.model.BurnInAlignment] =
      scala
        .Option(impl.alignment())
        .map(value => zio.aws.medialive.model.BurnInAlignment.wrap(value))
    override val backgroundColor
        : Option[zio.aws.medialive.model.BurnInBackgroundColor] = scala
      .Option(impl.backgroundColor())
      .map(value => zio.aws.medialive.model.BurnInBackgroundColor.wrap(value))
    override val backgroundOpacity: Option[__integerMin0Max255] = scala
      .Option(impl.backgroundOpacity())
      .map(value => value: __integerMin0Max255)
    override val font: Option[zio.aws.medialive.model.InputLocation.ReadOnly] =
      scala
        .Option(impl.font())
        .map(value => zio.aws.medialive.model.InputLocation.wrap(value))
    override val fontColor: Option[zio.aws.medialive.model.BurnInFontColor] =
      scala
        .Option(impl.fontColor())
        .map(value => zio.aws.medialive.model.BurnInFontColor.wrap(value))
    override val fontOpacity: Option[__integerMin0Max255] =
      scala.Option(impl.fontOpacity()).map(value => value: __integerMin0Max255)
    override val fontResolution: Option[__integerMin96Max600] = scala
      .Option(impl.fontResolution())
      .map(value => value: __integerMin96Max600)
    override val fontSize: Option[__string] =
      scala.Option(impl.fontSize()).map(value => value: __string)
    override val outlineColor
        : Option[zio.aws.medialive.model.BurnInOutlineColor] = scala
      .Option(impl.outlineColor())
      .map(value => zio.aws.medialive.model.BurnInOutlineColor.wrap(value))
    override val outlineSize: Option[__integerMin0Max10] =
      scala.Option(impl.outlineSize()).map(value => value: __integerMin0Max10)
    override val shadowColor
        : Option[zio.aws.medialive.model.BurnInShadowColor] = scala
      .Option(impl.shadowColor())
      .map(value => zio.aws.medialive.model.BurnInShadowColor.wrap(value))
    override val shadowOpacity: Option[__integerMin0Max255] = scala
      .Option(impl.shadowOpacity())
      .map(value => value: __integerMin0Max255)
    override val shadowXOffset: Option[__integer] =
      scala.Option(impl.shadowXOffset()).map(value => value: __integer)
    override val shadowYOffset: Option[__integer] =
      scala.Option(impl.shadowYOffset()).map(value => value: __integer)
    override val teletextGridControl
        : Option[zio.aws.medialive.model.BurnInTeletextGridControl] = scala
      .Option(impl.teletextGridControl())
      .map(value =>
        zio.aws.medialive.model.BurnInTeletextGridControl.wrap(value)
      )
    override val xPosition: Option[__integerMin0] =
      scala.Option(impl.xPosition()).map(value => value: __integerMin0)
    override val yPosition: Option[__integerMin0] =
      scala.Option(impl.yPosition()).map(value => value: __integerMin0)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.BurnInDestinationSettings
  ): zio.aws.medialive.model.BurnInDestinationSettings.ReadOnly = new Wrapper(
    impl
  )
}
