package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait BurnInShadowColor {
  def unwrap: software.amazon.awssdk.services.medialive.model.BurnInShadowColor
}
object BurnInShadowColor {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.BurnInShadowColor
  ): zio.aws.medialive.model.BurnInShadowColor = value match {
    case software.amazon.awssdk.services.medialive.model.BurnInShadowColor.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.BurnInShadowColor.BLACK =>
      val r = BLACK
      r
    case software.amazon.awssdk.services.medialive.model.BurnInShadowColor.NONE =>
      val r = NONE
      r
    case software.amazon.awssdk.services.medialive.model.BurnInShadowColor.WHITE =>
      val r = WHITE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.BurnInShadowColor {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.BurnInShadowColor =
      software.amazon.awssdk.services.medialive.model.BurnInShadowColor.UNKNOWN_TO_SDK_VERSION
  }
  case object BLACK extends zio.aws.medialive.model.BurnInShadowColor {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.BurnInShadowColor =
      software.amazon.awssdk.services.medialive.model.BurnInShadowColor.BLACK
  }
  case object NONE extends zio.aws.medialive.model.BurnInShadowColor {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.BurnInShadowColor =
      software.amazon.awssdk.services.medialive.model.BurnInShadowColor.NONE
  }
  case object WHITE extends zio.aws.medialive.model.BurnInShadowColor {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.BurnInShadowColor =
      software.amazon.awssdk.services.medialive.model.BurnInShadowColor.WHITE
  }
}
