package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class CaptionDescription(
    captionSelectorName: __string,
    destinationSettings: Option[
      zio.aws.medialive.model.CaptionDestinationSettings
    ] = None,
    languageCode: Option[__string] = None,
    languageDescription: Option[__string] = None,
    name: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.CaptionDescription = {
    import CaptionDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.CaptionDescription
      .builder()
      .captionSelectorName(captionSelectorName: java.lang.String)
      .optionallyWith(destinationSettings.map(value => value.buildAwsValue()))(
        _.destinationSettings
      )
      .optionallyWith(languageCode.map(value => value: java.lang.String))(
        _.languageCode
      )
      .optionallyWith(
        languageDescription.map(value => value: java.lang.String)
      )(_.languageDescription)
      .name(name: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.CaptionDescription.ReadOnly =
    zio.aws.medialive.model.CaptionDescription.wrap(buildAwsValue())
}
object CaptionDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.CaptionDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.CaptionDescription =
      zio.aws.medialive.model.CaptionDescription(
        captionSelectorName,
        destinationSettings.map(value => value.asEditable),
        languageCode.map(value => value),
        languageDescription.map(value => value),
        name
      )
    def captionSelectorName: __string
    def destinationSettings
        : Option[zio.aws.medialive.model.CaptionDestinationSettings.ReadOnly]
    def languageCode: Option[__string]
    def languageDescription: Option[__string]
    def name: __string
    def getCaptionSelectorName: ZIO[Any, Nothing, __string] =
      ZIO.succeed(captionSelectorName)
    def getDestinationSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.CaptionDestinationSettings.ReadOnly
    ] = AwsError.unwrapOptionField("destinationSettings", destinationSettings)
    def getLanguageCode: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("languageCode", languageCode)
    def getLanguageDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("languageDescription", languageDescription)
    def getName: ZIO[Any, Nothing, __string] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.CaptionDescription
  ) extends zio.aws.medialive.model.CaptionDescription.ReadOnly {
    override val captionSelectorName: __string =
      impl.captionSelectorName(): __string
    override val destinationSettings
        : Option[zio.aws.medialive.model.CaptionDestinationSettings.ReadOnly] =
      scala
        .Option(impl.destinationSettings())
        .map(value =>
          zio.aws.medialive.model.CaptionDestinationSettings.wrap(value)
        )
    override val languageCode: Option[__string] =
      scala.Option(impl.languageCode()).map(value => value: __string)
    override val languageDescription: Option[__string] =
      scala.Option(impl.languageDescription()).map(value => value: __string)
    override val name: __string = impl.name(): __string
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.CaptionDescription
  ): zio.aws.medialive.model.CaptionDescription.ReadOnly = new Wrapper(impl)
}
