package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CaptionDestinationSettings(
    aribDestinationSettings: Option[
      zio.aws.medialive.model.AribDestinationSettings
    ] = None,
    burnInDestinationSettings: Option[
      zio.aws.medialive.model.BurnInDestinationSettings
    ] = None,
    dvbSubDestinationSettings: Option[
      zio.aws.medialive.model.DvbSubDestinationSettings
    ] = None,
    ebuTtDDestinationSettings: Option[
      zio.aws.medialive.model.EbuTtDDestinationSettings
    ] = None,
    embeddedDestinationSettings: Option[
      zio.aws.medialive.model.EmbeddedDestinationSettings
    ] = None,
    embeddedPlusScte20DestinationSettings: Option[
      zio.aws.medialive.model.EmbeddedPlusScte20DestinationSettings
    ] = None,
    rtmpCaptionInfoDestinationSettings: Option[
      zio.aws.medialive.model.RtmpCaptionInfoDestinationSettings
    ] = None,
    scte20PlusEmbeddedDestinationSettings: Option[
      zio.aws.medialive.model.Scte20PlusEmbeddedDestinationSettings
    ] = None,
    scte27DestinationSettings: Option[
      zio.aws.medialive.model.Scte27DestinationSettings
    ] = None,
    smpteTtDestinationSettings: Option[
      zio.aws.medialive.model.SmpteTtDestinationSettings
    ] = None,
    teletextDestinationSettings: Option[
      zio.aws.medialive.model.TeletextDestinationSettings
    ] = None,
    ttmlDestinationSettings: Option[
      zio.aws.medialive.model.TtmlDestinationSettings
    ] = None,
    webvttDestinationSettings: Option[
      zio.aws.medialive.model.WebvttDestinationSettings
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.CaptionDestinationSettings = {
    import CaptionDestinationSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.CaptionDestinationSettings
      .builder()
      .optionallyWith(
        aribDestinationSettings.map(value => value.buildAwsValue())
      )(_.aribDestinationSettings)
      .optionallyWith(
        burnInDestinationSettings.map(value => value.buildAwsValue())
      )(_.burnInDestinationSettings)
      .optionallyWith(
        dvbSubDestinationSettings.map(value => value.buildAwsValue())
      )(_.dvbSubDestinationSettings)
      .optionallyWith(
        ebuTtDDestinationSettings.map(value => value.buildAwsValue())
      )(_.ebuTtDDestinationSettings)
      .optionallyWith(
        embeddedDestinationSettings.map(value => value.buildAwsValue())
      )(_.embeddedDestinationSettings)
      .optionallyWith(
        embeddedPlusScte20DestinationSettings.map(value =>
          value.buildAwsValue()
        )
      )(_.embeddedPlusScte20DestinationSettings)
      .optionallyWith(
        rtmpCaptionInfoDestinationSettings.map(value => value.buildAwsValue())
      )(_.rtmpCaptionInfoDestinationSettings)
      .optionallyWith(
        scte20PlusEmbeddedDestinationSettings.map(value =>
          value.buildAwsValue()
        )
      )(_.scte20PlusEmbeddedDestinationSettings)
      .optionallyWith(
        scte27DestinationSettings.map(value => value.buildAwsValue())
      )(_.scte27DestinationSettings)
      .optionallyWith(
        smpteTtDestinationSettings.map(value => value.buildAwsValue())
      )(_.smpteTtDestinationSettings)
      .optionallyWith(
        teletextDestinationSettings.map(value => value.buildAwsValue())
      )(_.teletextDestinationSettings)
      .optionallyWith(
        ttmlDestinationSettings.map(value => value.buildAwsValue())
      )(_.ttmlDestinationSettings)
      .optionallyWith(
        webvttDestinationSettings.map(value => value.buildAwsValue())
      )(_.webvttDestinationSettings)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.CaptionDestinationSettings.ReadOnly =
    zio.aws.medialive.model.CaptionDestinationSettings.wrap(buildAwsValue())
}
object CaptionDestinationSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.CaptionDestinationSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.CaptionDestinationSettings =
      zio.aws.medialive.model.CaptionDestinationSettings(
        aribDestinationSettings.map(value => value.asEditable),
        burnInDestinationSettings.map(value => value.asEditable),
        dvbSubDestinationSettings.map(value => value.asEditable),
        ebuTtDDestinationSettings.map(value => value.asEditable),
        embeddedDestinationSettings.map(value => value.asEditable),
        embeddedPlusScte20DestinationSettings.map(value => value.asEditable),
        rtmpCaptionInfoDestinationSettings.map(value => value.asEditable),
        scte20PlusEmbeddedDestinationSettings.map(value => value.asEditable),
        scte27DestinationSettings.map(value => value.asEditable),
        smpteTtDestinationSettings.map(value => value.asEditable),
        teletextDestinationSettings.map(value => value.asEditable),
        ttmlDestinationSettings.map(value => value.asEditable),
        webvttDestinationSettings.map(value => value.asEditable)
      )
    def aribDestinationSettings
        : Option[zio.aws.medialive.model.AribDestinationSettings.ReadOnly]
    def burnInDestinationSettings
        : Option[zio.aws.medialive.model.BurnInDestinationSettings.ReadOnly]
    def dvbSubDestinationSettings
        : Option[zio.aws.medialive.model.DvbSubDestinationSettings.ReadOnly]
    def ebuTtDDestinationSettings
        : Option[zio.aws.medialive.model.EbuTtDDestinationSettings.ReadOnly]
    def embeddedDestinationSettings
        : Option[zio.aws.medialive.model.EmbeddedDestinationSettings.ReadOnly]
    def embeddedPlusScte20DestinationSettings: Option[
      zio.aws.medialive.model.EmbeddedPlusScte20DestinationSettings.ReadOnly
    ]
    def rtmpCaptionInfoDestinationSettings: Option[
      zio.aws.medialive.model.RtmpCaptionInfoDestinationSettings.ReadOnly
    ]
    def scte20PlusEmbeddedDestinationSettings: Option[
      zio.aws.medialive.model.Scte20PlusEmbeddedDestinationSettings.ReadOnly
    ]
    def scte27DestinationSettings
        : Option[zio.aws.medialive.model.Scte27DestinationSettings.ReadOnly]
    def smpteTtDestinationSettings
        : Option[zio.aws.medialive.model.SmpteTtDestinationSettings.ReadOnly]
    def teletextDestinationSettings
        : Option[zio.aws.medialive.model.TeletextDestinationSettings.ReadOnly]
    def ttmlDestinationSettings
        : Option[zio.aws.medialive.model.TtmlDestinationSettings.ReadOnly]
    def webvttDestinationSettings
        : Option[zio.aws.medialive.model.WebvttDestinationSettings.ReadOnly]
    def getAribDestinationSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.AribDestinationSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "aribDestinationSettings",
      aribDestinationSettings
    )
    def getBurnInDestinationSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.BurnInDestinationSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "burnInDestinationSettings",
      burnInDestinationSettings
    )
    def getDvbSubDestinationSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.DvbSubDestinationSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "dvbSubDestinationSettings",
      dvbSubDestinationSettings
    )
    def getEbuTtDDestinationSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.EbuTtDDestinationSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "ebuTtDDestinationSettings",
      ebuTtDDestinationSettings
    )
    def getEmbeddedDestinationSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.EmbeddedDestinationSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "embeddedDestinationSettings",
      embeddedDestinationSettings
    )
    def getEmbeddedPlusScte20DestinationSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.EmbeddedPlusScte20DestinationSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "embeddedPlusScte20DestinationSettings",
      embeddedPlusScte20DestinationSettings
    )
    def getRtmpCaptionInfoDestinationSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.RtmpCaptionInfoDestinationSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "rtmpCaptionInfoDestinationSettings",
      rtmpCaptionInfoDestinationSettings
    )
    def getScte20PlusEmbeddedDestinationSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.Scte20PlusEmbeddedDestinationSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "scte20PlusEmbeddedDestinationSettings",
      scte20PlusEmbeddedDestinationSettings
    )
    def getScte27DestinationSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.Scte27DestinationSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "scte27DestinationSettings",
      scte27DestinationSettings
    )
    def getSmpteTtDestinationSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.SmpteTtDestinationSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "smpteTtDestinationSettings",
      smpteTtDestinationSettings
    )
    def getTeletextDestinationSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.TeletextDestinationSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "teletextDestinationSettings",
      teletextDestinationSettings
    )
    def getTtmlDestinationSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.TtmlDestinationSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "ttmlDestinationSettings",
      ttmlDestinationSettings
    )
    def getWebvttDestinationSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.WebvttDestinationSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "webvttDestinationSettings",
      webvttDestinationSettings
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.CaptionDestinationSettings
  ) extends zio.aws.medialive.model.CaptionDestinationSettings.ReadOnly {
    override val aribDestinationSettings
        : Option[zio.aws.medialive.model.AribDestinationSettings.ReadOnly] =
      scala
        .Option(impl.aribDestinationSettings())
        .map(value =>
          zio.aws.medialive.model.AribDestinationSettings.wrap(value)
        )
    override val burnInDestinationSettings
        : Option[zio.aws.medialive.model.BurnInDestinationSettings.ReadOnly] =
      scala
        .Option(impl.burnInDestinationSettings())
        .map(value =>
          zio.aws.medialive.model.BurnInDestinationSettings.wrap(value)
        )
    override val dvbSubDestinationSettings
        : Option[zio.aws.medialive.model.DvbSubDestinationSettings.ReadOnly] =
      scala
        .Option(impl.dvbSubDestinationSettings())
        .map(value =>
          zio.aws.medialive.model.DvbSubDestinationSettings.wrap(value)
        )
    override val ebuTtDDestinationSettings
        : Option[zio.aws.medialive.model.EbuTtDDestinationSettings.ReadOnly] =
      scala
        .Option(impl.ebuTtDDestinationSettings())
        .map(value =>
          zio.aws.medialive.model.EbuTtDDestinationSettings.wrap(value)
        )
    override val embeddedDestinationSettings
        : Option[zio.aws.medialive.model.EmbeddedDestinationSettings.ReadOnly] =
      scala
        .Option(impl.embeddedDestinationSettings())
        .map(value =>
          zio.aws.medialive.model.EmbeddedDestinationSettings.wrap(value)
        )
    override val embeddedPlusScte20DestinationSettings: Option[
      zio.aws.medialive.model.EmbeddedPlusScte20DestinationSettings.ReadOnly
    ] = scala
      .Option(impl.embeddedPlusScte20DestinationSettings())
      .map(value =>
        zio.aws.medialive.model.EmbeddedPlusScte20DestinationSettings
          .wrap(value)
      )
    override val rtmpCaptionInfoDestinationSettings: Option[
      zio.aws.medialive.model.RtmpCaptionInfoDestinationSettings.ReadOnly
    ] = scala
      .Option(impl.rtmpCaptionInfoDestinationSettings())
      .map(value =>
        zio.aws.medialive.model.RtmpCaptionInfoDestinationSettings.wrap(value)
      )
    override val scte20PlusEmbeddedDestinationSettings: Option[
      zio.aws.medialive.model.Scte20PlusEmbeddedDestinationSettings.ReadOnly
    ] = scala
      .Option(impl.scte20PlusEmbeddedDestinationSettings())
      .map(value =>
        zio.aws.medialive.model.Scte20PlusEmbeddedDestinationSettings
          .wrap(value)
      )
    override val scte27DestinationSettings
        : Option[zio.aws.medialive.model.Scte27DestinationSettings.ReadOnly] =
      scala
        .Option(impl.scte27DestinationSettings())
        .map(value =>
          zio.aws.medialive.model.Scte27DestinationSettings.wrap(value)
        )
    override val smpteTtDestinationSettings
        : Option[zio.aws.medialive.model.SmpteTtDestinationSettings.ReadOnly] =
      scala
        .Option(impl.smpteTtDestinationSettings())
        .map(value =>
          zio.aws.medialive.model.SmpteTtDestinationSettings.wrap(value)
        )
    override val teletextDestinationSettings
        : Option[zio.aws.medialive.model.TeletextDestinationSettings.ReadOnly] =
      scala
        .Option(impl.teletextDestinationSettings())
        .map(value =>
          zio.aws.medialive.model.TeletextDestinationSettings.wrap(value)
        )
    override val ttmlDestinationSettings
        : Option[zio.aws.medialive.model.TtmlDestinationSettings.ReadOnly] =
      scala
        .Option(impl.ttmlDestinationSettings())
        .map(value =>
          zio.aws.medialive.model.TtmlDestinationSettings.wrap(value)
        )
    override val webvttDestinationSettings
        : Option[zio.aws.medialive.model.WebvttDestinationSettings.ReadOnly] =
      scala
        .Option(impl.webvttDestinationSettings())
        .map(value =>
          zio.aws.medialive.model.WebvttDestinationSettings.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.CaptionDestinationSettings
  ): zio.aws.medialive.model.CaptionDestinationSettings.ReadOnly = new Wrapper(
    impl
  )
}
