package zio.aws.medialive.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.medialive.model.primitives.{
  __stringMin1,
  __stringMin3Max3,
  __integerMin1Max4
}
import scala.jdk.CollectionConverters._
final case class CaptionLanguageMapping(
    captionChannel: __integerMin1Max4,
    languageCode: __stringMin3Max3,
    languageDescription: __stringMin1
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.CaptionLanguageMapping = {
    import CaptionLanguageMapping.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.CaptionLanguageMapping
      .builder()
      .captionChannel(captionChannel: Integer)
      .languageCode(languageCode: java.lang.String)
      .languageDescription(languageDescription: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.CaptionLanguageMapping.ReadOnly =
    zio.aws.medialive.model.CaptionLanguageMapping.wrap(buildAwsValue())
}
object CaptionLanguageMapping {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.CaptionLanguageMapping
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.CaptionLanguageMapping =
      zio.aws.medialive.model.CaptionLanguageMapping(
        captionChannel,
        languageCode,
        languageDescription
      )
    def captionChannel: __integerMin1Max4
    def languageCode: __stringMin3Max3
    def languageDescription: __stringMin1
    def getCaptionChannel: ZIO[Any, Nothing, __integerMin1Max4] =
      ZIO.succeed(captionChannel)
    def getLanguageCode: ZIO[Any, Nothing, __stringMin3Max3] =
      ZIO.succeed(languageCode)
    def getLanguageDescription: ZIO[Any, Nothing, __stringMin1] =
      ZIO.succeed(languageDescription)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.CaptionLanguageMapping
  ) extends zio.aws.medialive.model.CaptionLanguageMapping.ReadOnly {
    override val captionChannel: __integerMin1Max4 =
      impl.captionChannel(): __integerMin1Max4
    override val languageCode: __stringMin3Max3 =
      impl.languageCode(): __stringMin3Max3
    override val languageDescription: __stringMin1 =
      impl.languageDescription(): __stringMin1
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.CaptionLanguageMapping
  ): zio.aws.medialive.model.CaptionLanguageMapping.ReadOnly = new Wrapper(impl)
}
