package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.{__stringMin1, __string}
import scala.jdk.CollectionConverters._
final case class CaptionSelector(
    languageCode: Option[__string] = None,
    name: __stringMin1,
    selectorSettings: Option[zio.aws.medialive.model.CaptionSelectorSettings] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.CaptionSelector = {
    import CaptionSelector.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.CaptionSelector
      .builder()
      .optionallyWith(languageCode.map(value => value: java.lang.String))(
        _.languageCode
      )
      .name(name: java.lang.String)
      .optionallyWith(selectorSettings.map(value => value.buildAwsValue()))(
        _.selectorSettings
      )
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.CaptionSelector.ReadOnly =
    zio.aws.medialive.model.CaptionSelector.wrap(buildAwsValue())
}
object CaptionSelector {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.CaptionSelector
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.CaptionSelector =
      zio.aws.medialive.model.CaptionSelector(
        languageCode.map(value => value),
        name,
        selectorSettings.map(value => value.asEditable)
      )
    def languageCode: Option[__string]
    def name: __stringMin1
    def selectorSettings
        : Option[zio.aws.medialive.model.CaptionSelectorSettings.ReadOnly]
    def getLanguageCode: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("languageCode", languageCode)
    def getName: ZIO[Any, Nothing, __stringMin1] = ZIO.succeed(name)
    def getSelectorSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.CaptionSelectorSettings.ReadOnly
    ] = AwsError.unwrapOptionField("selectorSettings", selectorSettings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.CaptionSelector
  ) extends zio.aws.medialive.model.CaptionSelector.ReadOnly {
    override val languageCode: Option[__string] =
      scala.Option(impl.languageCode()).map(value => value: __string)
    override val name: __stringMin1 = impl.name(): __stringMin1
    override val selectorSettings
        : Option[zio.aws.medialive.model.CaptionSelectorSettings.ReadOnly] =
      scala
        .Option(impl.selectorSettings())
        .map(value =>
          zio.aws.medialive.model.CaptionSelectorSettings.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.CaptionSelector
  ): zio.aws.medialive.model.CaptionSelector.ReadOnly = new Wrapper(impl)
}
