package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CaptionSelectorSettings(
    ancillarySourceSettings: Option[
      zio.aws.medialive.model.AncillarySourceSettings
    ] = None,
    aribSourceSettings: Option[zio.aws.medialive.model.AribSourceSettings] =
      None,
    dvbSubSourceSettings: Option[zio.aws.medialive.model.DvbSubSourceSettings] =
      None,
    embeddedSourceSettings: Option[
      zio.aws.medialive.model.EmbeddedSourceSettings
    ] = None,
    scte20SourceSettings: Option[zio.aws.medialive.model.Scte20SourceSettings] =
      None,
    scte27SourceSettings: Option[zio.aws.medialive.model.Scte27SourceSettings] =
      None,
    teletextSourceSettings: Option[
      zio.aws.medialive.model.TeletextSourceSettings
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.CaptionSelectorSettings = {
    import CaptionSelectorSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.CaptionSelectorSettings
      .builder()
      .optionallyWith(
        ancillarySourceSettings.map(value => value.buildAwsValue())
      )(_.ancillarySourceSettings)
      .optionallyWith(aribSourceSettings.map(value => value.buildAwsValue()))(
        _.aribSourceSettings
      )
      .optionallyWith(dvbSubSourceSettings.map(value => value.buildAwsValue()))(
        _.dvbSubSourceSettings
      )
      .optionallyWith(
        embeddedSourceSettings.map(value => value.buildAwsValue())
      )(_.embeddedSourceSettings)
      .optionallyWith(scte20SourceSettings.map(value => value.buildAwsValue()))(
        _.scte20SourceSettings
      )
      .optionallyWith(scte27SourceSettings.map(value => value.buildAwsValue()))(
        _.scte27SourceSettings
      )
      .optionallyWith(
        teletextSourceSettings.map(value => value.buildAwsValue())
      )(_.teletextSourceSettings)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.CaptionSelectorSettings.ReadOnly =
    zio.aws.medialive.model.CaptionSelectorSettings.wrap(buildAwsValue())
}
object CaptionSelectorSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.CaptionSelectorSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.CaptionSelectorSettings =
      zio.aws.medialive.model.CaptionSelectorSettings(
        ancillarySourceSettings.map(value => value.asEditable),
        aribSourceSettings.map(value => value.asEditable),
        dvbSubSourceSettings.map(value => value.asEditable),
        embeddedSourceSettings.map(value => value.asEditable),
        scte20SourceSettings.map(value => value.asEditable),
        scte27SourceSettings.map(value => value.asEditable),
        teletextSourceSettings.map(value => value.asEditable)
      )
    def ancillarySourceSettings
        : Option[zio.aws.medialive.model.AncillarySourceSettings.ReadOnly]
    def aribSourceSettings
        : Option[zio.aws.medialive.model.AribSourceSettings.ReadOnly]
    def dvbSubSourceSettings
        : Option[zio.aws.medialive.model.DvbSubSourceSettings.ReadOnly]
    def embeddedSourceSettings
        : Option[zio.aws.medialive.model.EmbeddedSourceSettings.ReadOnly]
    def scte20SourceSettings
        : Option[zio.aws.medialive.model.Scte20SourceSettings.ReadOnly]
    def scte27SourceSettings
        : Option[zio.aws.medialive.model.Scte27SourceSettings.ReadOnly]
    def teletextSourceSettings
        : Option[zio.aws.medialive.model.TeletextSourceSettings.ReadOnly]
    def getAncillarySourceSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.AncillarySourceSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "ancillarySourceSettings",
      ancillarySourceSettings
    )
    def getAribSourceSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.AribSourceSettings.ReadOnly
    ] = AwsError.unwrapOptionField("aribSourceSettings", aribSourceSettings)
    def getDvbSubSourceSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.DvbSubSourceSettings.ReadOnly
    ] = AwsError.unwrapOptionField("dvbSubSourceSettings", dvbSubSourceSettings)
    def getEmbeddedSourceSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.EmbeddedSourceSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "embeddedSourceSettings",
      embeddedSourceSettings
    )
    def getScte20SourceSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.Scte20SourceSettings.ReadOnly
    ] = AwsError.unwrapOptionField("scte20SourceSettings", scte20SourceSettings)
    def getScte27SourceSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.Scte27SourceSettings.ReadOnly
    ] = AwsError.unwrapOptionField("scte27SourceSettings", scte27SourceSettings)
    def getTeletextSourceSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.TeletextSourceSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "teletextSourceSettings",
      teletextSourceSettings
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.CaptionSelectorSettings
  ) extends zio.aws.medialive.model.CaptionSelectorSettings.ReadOnly {
    override val ancillarySourceSettings
        : Option[zio.aws.medialive.model.AncillarySourceSettings.ReadOnly] =
      scala
        .Option(impl.ancillarySourceSettings())
        .map(value =>
          zio.aws.medialive.model.AncillarySourceSettings.wrap(value)
        )
    override val aribSourceSettings
        : Option[zio.aws.medialive.model.AribSourceSettings.ReadOnly] = scala
      .Option(impl.aribSourceSettings())
      .map(value => zio.aws.medialive.model.AribSourceSettings.wrap(value))
    override val dvbSubSourceSettings
        : Option[zio.aws.medialive.model.DvbSubSourceSettings.ReadOnly] = scala
      .Option(impl.dvbSubSourceSettings())
      .map(value => zio.aws.medialive.model.DvbSubSourceSettings.wrap(value))
    override val embeddedSourceSettings
        : Option[zio.aws.medialive.model.EmbeddedSourceSettings.ReadOnly] =
      scala
        .Option(impl.embeddedSourceSettings())
        .map(value =>
          zio.aws.medialive.model.EmbeddedSourceSettings.wrap(value)
        )
    override val scte20SourceSettings
        : Option[zio.aws.medialive.model.Scte20SourceSettings.ReadOnly] = scala
      .Option(impl.scte20SourceSettings())
      .map(value => zio.aws.medialive.model.Scte20SourceSettings.wrap(value))
    override val scte27SourceSettings
        : Option[zio.aws.medialive.model.Scte27SourceSettings.ReadOnly] = scala
      .Option(impl.scte27SourceSettings())
      .map(value => zio.aws.medialive.model.Scte27SourceSettings.wrap(value))
    override val teletextSourceSettings
        : Option[zio.aws.medialive.model.TeletextSourceSettings.ReadOnly] =
      scala
        .Option(impl.teletextSourceSettings())
        .map(value =>
          zio.aws.medialive.model.TeletextSourceSettings.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.CaptionSelectorSettings
  ): zio.aws.medialive.model.CaptionSelectorSettings.ReadOnly = new Wrapper(
    impl
  )
}
