package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait CdiInputResolution {
  def unwrap: software.amazon.awssdk.services.medialive.model.CdiInputResolution
}
object CdiInputResolution {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.CdiInputResolution
  ): zio.aws.medialive.model.CdiInputResolution = value match {
    case software.amazon.awssdk.services.medialive.model.CdiInputResolution.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.CdiInputResolution.SD =>
      val r = SD
      r
    case software.amazon.awssdk.services.medialive.model.CdiInputResolution.HD =>
      val r = HD
      r
    case software.amazon.awssdk.services.medialive.model.CdiInputResolution.FHD =>
      val r = FHD
      r
    case software.amazon.awssdk.services.medialive.model.CdiInputResolution.UHD =>
      val r = UHD
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.CdiInputResolution {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.CdiInputResolution =
      software.amazon.awssdk.services.medialive.model.CdiInputResolution.UNKNOWN_TO_SDK_VERSION
  }
  case object SD extends zio.aws.medialive.model.CdiInputResolution {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.CdiInputResolution =
      software.amazon.awssdk.services.medialive.model.CdiInputResolution.SD
  }
  case object HD extends zio.aws.medialive.model.CdiInputResolution {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.CdiInputResolution =
      software.amazon.awssdk.services.medialive.model.CdiInputResolution.HD
  }
  case object FHD extends zio.aws.medialive.model.CdiInputResolution {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.CdiInputResolution =
      software.amazon.awssdk.services.medialive.model.CdiInputResolution.FHD
  }
  case object UHD extends zio.aws.medialive.model.CdiInputResolution {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.CdiInputResolution =
      software.amazon.awssdk.services.medialive.model.CdiInputResolution.UHD
  }
}
