package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CdiInputSpecification(
    resolution: Option[zio.aws.medialive.model.CdiInputResolution] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.CdiInputSpecification = {
    import CdiInputSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.CdiInputSpecification
      .builder()
      .optionallyWith(resolution.map(value => value.unwrap))(_.resolution)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.CdiInputSpecification.ReadOnly =
    zio.aws.medialive.model.CdiInputSpecification.wrap(buildAwsValue())
}
object CdiInputSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.CdiInputSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.CdiInputSpecification =
      zio.aws.medialive.model
        .CdiInputSpecification(resolution.map(value => value))
    def resolution: Option[zio.aws.medialive.model.CdiInputResolution]
    def getResolution
        : ZIO[Any, AwsError, zio.aws.medialive.model.CdiInputResolution] =
      AwsError.unwrapOptionField("resolution", resolution)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.CdiInputSpecification
  ) extends zio.aws.medialive.model.CdiInputSpecification.ReadOnly {
    override val resolution
        : Option[zio.aws.medialive.model.CdiInputResolution] = scala
      .Option(impl.resolution())
      .map(value => zio.aws.medialive.model.CdiInputResolution.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.CdiInputSpecification
  ): zio.aws.medialive.model.CdiInputSpecification.ReadOnly = new Wrapper(impl)
}
