package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait ChannelClass {
  def unwrap: software.amazon.awssdk.services.medialive.model.ChannelClass
}
object ChannelClass {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.ChannelClass
  ): zio.aws.medialive.model.ChannelClass = value match {
    case software.amazon.awssdk.services.medialive.model.ChannelClass.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.ChannelClass.STANDARD =>
      val r = STANDARD
      r
    case software.amazon.awssdk.services.medialive.model.ChannelClass.SINGLE_PIPELINE =>
      val r = SINGLE_PIPELINE
      r
  }
  case object unknownToSdkVersion extends zio.aws.medialive.model.ChannelClass {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.ChannelClass =
      software.amazon.awssdk.services.medialive.model.ChannelClass.UNKNOWN_TO_SDK_VERSION
  }
  case object STANDARD extends zio.aws.medialive.model.ChannelClass {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.ChannelClass =
      software.amazon.awssdk.services.medialive.model.ChannelClass.STANDARD
  }
  case object SINGLE_PIPELINE extends zio.aws.medialive.model.ChannelClass {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.ChannelClass =
      software.amazon.awssdk.services.medialive.model.ChannelClass.SINGLE_PIPELINE
  }
}
