package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class ChannelEgressEndpoint(sourceIp: Option[__string] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.ChannelEgressEndpoint = {
    import ChannelEgressEndpoint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.ChannelEgressEndpoint
      .builder()
      .optionallyWith(sourceIp.map(value => value: java.lang.String))(
        _.sourceIp
      )
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.ChannelEgressEndpoint.ReadOnly =
    zio.aws.medialive.model.ChannelEgressEndpoint.wrap(buildAwsValue())
}
object ChannelEgressEndpoint {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.ChannelEgressEndpoint
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.ChannelEgressEndpoint =
      zio.aws.medialive.model
        .ChannelEgressEndpoint(sourceIp.map(value => value))
    def sourceIp: Option[__string]
    def getSourceIp: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("sourceIp", sourceIp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.ChannelEgressEndpoint
  ) extends zio.aws.medialive.model.ChannelEgressEndpoint.ReadOnly {
    override val sourceIp: Option[__string] =
      scala.Option(impl.sourceIp()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.ChannelEgressEndpoint
  ): zio.aws.medialive.model.ChannelEgressEndpoint.ReadOnly = new Wrapper(impl)
}
