package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait ChannelState {
  def unwrap: software.amazon.awssdk.services.medialive.model.ChannelState
}
object ChannelState {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.ChannelState
  ): zio.aws.medialive.model.ChannelState = value match {
    case software.amazon.awssdk.services.medialive.model.ChannelState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.ChannelState.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.medialive.model.ChannelState.CREATE_FAILED =>
      val r = CREATE_FAILED
      r
    case software.amazon.awssdk.services.medialive.model.ChannelState.IDLE =>
      val r = IDLE
      r
    case software.amazon.awssdk.services.medialive.model.ChannelState.STARTING =>
      val r = STARTING
      r
    case software.amazon.awssdk.services.medialive.model.ChannelState.RUNNING =>
      val r = RUNNING
      r
    case software.amazon.awssdk.services.medialive.model.ChannelState.RECOVERING =>
      val r = RECOVERING
      r
    case software.amazon.awssdk.services.medialive.model.ChannelState.STOPPING =>
      val r = STOPPING
      r
    case software.amazon.awssdk.services.medialive.model.ChannelState.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.medialive.model.ChannelState.DELETED =>
      val r = DELETED
      r
    case software.amazon.awssdk.services.medialive.model.ChannelState.UPDATING =>
      val r = UPDATING
      r
    case software.amazon.awssdk.services.medialive.model.ChannelState.UPDATE_FAILED =>
      val r = UPDATE_FAILED
      r
  }
  case object unknownToSdkVersion extends zio.aws.medialive.model.ChannelState {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.ChannelState =
      software.amazon.awssdk.services.medialive.model.ChannelState.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATING extends zio.aws.medialive.model.ChannelState {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.ChannelState =
      software.amazon.awssdk.services.medialive.model.ChannelState.CREATING
  }
  case object CREATE_FAILED extends zio.aws.medialive.model.ChannelState {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.ChannelState =
      software.amazon.awssdk.services.medialive.model.ChannelState.CREATE_FAILED
  }
  case object IDLE extends zio.aws.medialive.model.ChannelState {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.ChannelState =
      software.amazon.awssdk.services.medialive.model.ChannelState.IDLE
  }
  case object STARTING extends zio.aws.medialive.model.ChannelState {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.ChannelState =
      software.amazon.awssdk.services.medialive.model.ChannelState.STARTING
  }
  case object RUNNING extends zio.aws.medialive.model.ChannelState {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.ChannelState =
      software.amazon.awssdk.services.medialive.model.ChannelState.RUNNING
  }
  case object RECOVERING extends zio.aws.medialive.model.ChannelState {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.ChannelState =
      software.amazon.awssdk.services.medialive.model.ChannelState.RECOVERING
  }
  case object STOPPING extends zio.aws.medialive.model.ChannelState {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.ChannelState =
      software.amazon.awssdk.services.medialive.model.ChannelState.STOPPING
  }
  case object DELETING extends zio.aws.medialive.model.ChannelState {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.ChannelState =
      software.amazon.awssdk.services.medialive.model.ChannelState.DELETING
  }
  case object DELETED extends zio.aws.medialive.model.ChannelState {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.ChannelState =
      software.amazon.awssdk.services.medialive.model.ChannelState.DELETED
  }
  case object UPDATING extends zio.aws.medialive.model.ChannelState {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.ChannelState =
      software.amazon.awssdk.services.medialive.model.ChannelState.UPDATING
  }
  case object UPDATE_FAILED extends zio.aws.medialive.model.ChannelState {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.ChannelState =
      software.amazon.awssdk.services.medialive.model.ChannelState.UPDATE_FAILED
  }
}
