package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait ContentType {
  def unwrap: software.amazon.awssdk.services.medialive.model.ContentType
}
object ContentType {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.ContentType
  ): zio.aws.medialive.model.ContentType = value match {
    case software.amazon.awssdk.services.medialive.model.ContentType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.ContentType.IMAGE_JPEG =>
      val r = `image/jpeg`
      r
  }
  case object unknownToSdkVersion extends zio.aws.medialive.model.ContentType {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.ContentType =
      software.amazon.awssdk.services.medialive.model.ContentType.UNKNOWN_TO_SDK_VERSION
  }
  case object `image/jpeg` extends zio.aws.medialive.model.ContentType {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.ContentType =
      software.amazon.awssdk.services.medialive.model.ContentType.IMAGE_JPEG
  }
}
