package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class CreateChannelRequest(
    cdiInputSpecification: Option[
      zio.aws.medialive.model.CdiInputSpecification
    ] = None,
    channelClass: Option[zio.aws.medialive.model.ChannelClass] = None,
    destinations: Option[Iterable[zio.aws.medialive.model.OutputDestination]] =
      None,
    encoderSettings: Option[zio.aws.medialive.model.EncoderSettings] = None,
    inputAttachments: Option[
      Iterable[zio.aws.medialive.model.InputAttachment]
    ] = None,
    inputSpecification: Option[zio.aws.medialive.model.InputSpecification] =
      None,
    logLevel: Option[zio.aws.medialive.model.LogLevel] = None,
    maintenance: Option[zio.aws.medialive.model.MaintenanceCreateSettings] =
      None,
    name: Option[__string] = None,
    requestId: Option[__string] = None,
    reserved: Option[__string] = None,
    roleArn: Option[__string] = None,
    tags: Option[Map[__string, __string]] = None,
    vpc: Option[zio.aws.medialive.model.VpcOutputSettings] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.CreateChannelRequest = {
    import CreateChannelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.CreateChannelRequest
      .builder()
      .optionallyWith(
        cdiInputSpecification.map(value => value.buildAwsValue())
      )(_.cdiInputSpecification)
      .optionallyWith(channelClass.map(value => value.unwrap))(_.channelClass)
      .optionallyWith(
        destinations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.destinations)
      .optionallyWith(encoderSettings.map(value => value.buildAwsValue()))(
        _.encoderSettings
      )
      .optionallyWith(
        inputAttachments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.inputAttachments)
      .optionallyWith(inputSpecification.map(value => value.buildAwsValue()))(
        _.inputSpecification
      )
      .optionallyWith(logLevel.map(value => value.unwrap))(_.logLevel)
      .optionallyWith(maintenance.map(value => value.buildAwsValue()))(
        _.maintenance
      )
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(requestId.map(value => value: java.lang.String))(
        _.requestId
      )
      .optionallyWith(reserved.map(value => value: java.lang.String))(
        _.reserved
      )
      .optionallyWith(roleArn.map(value => value: java.lang.String))(_.roleArn)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(vpc.map(value => value.buildAwsValue()))(_.vpc)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.CreateChannelRequest.ReadOnly =
    zio.aws.medialive.model.CreateChannelRequest.wrap(buildAwsValue())
}
object CreateChannelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.CreateChannelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.CreateChannelRequest =
      zio.aws.medialive.model.CreateChannelRequest(
        cdiInputSpecification.map(value => value.asEditable),
        channelClass.map(value => value),
        destinations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        encoderSettings.map(value => value.asEditable),
        inputAttachments.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        inputSpecification.map(value => value.asEditable),
        logLevel.map(value => value),
        maintenance.map(value => value.asEditable),
        name.map(value => value),
        requestId.map(value => value),
        reserved.map(value => value),
        roleArn.map(value => value),
        tags.map(value => value),
        vpc.map(value => value.asEditable)
      )
    def cdiInputSpecification
        : Option[zio.aws.medialive.model.CdiInputSpecification.ReadOnly]
    def channelClass: Option[zio.aws.medialive.model.ChannelClass]
    def destinations
        : Option[List[zio.aws.medialive.model.OutputDestination.ReadOnly]]
    def encoderSettings
        : Option[zio.aws.medialive.model.EncoderSettings.ReadOnly]
    def inputAttachments
        : Option[List[zio.aws.medialive.model.InputAttachment.ReadOnly]]
    def inputSpecification
        : Option[zio.aws.medialive.model.InputSpecification.ReadOnly]
    def logLevel: Option[zio.aws.medialive.model.LogLevel]
    def maintenance
        : Option[zio.aws.medialive.model.MaintenanceCreateSettings.ReadOnly]
    def name: Option[__string]
    def requestId: Option[__string]
    def reserved: Option[__string]
    def roleArn: Option[__string]
    def tags: Option[Map[__string, __string]]
    def vpc: Option[zio.aws.medialive.model.VpcOutputSettings.ReadOnly]
    def getCdiInputSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.CdiInputSpecification.ReadOnly
    ] =
      AwsError.unwrapOptionField("cdiInputSpecification", cdiInputSpecification)
    def getChannelClass
        : ZIO[Any, AwsError, zio.aws.medialive.model.ChannelClass] =
      AwsError.unwrapOptionField("channelClass", channelClass)
    def getDestinations: ZIO[Any, AwsError, List[
      zio.aws.medialive.model.OutputDestination.ReadOnly
    ]] = AwsError.unwrapOptionField("destinations", destinations)
    def getEncoderSettings
        : ZIO[Any, AwsError, zio.aws.medialive.model.EncoderSettings.ReadOnly] =
      AwsError.unwrapOptionField("encoderSettings", encoderSettings)
    def getInputAttachments: ZIO[Any, AwsError, List[
      zio.aws.medialive.model.InputAttachment.ReadOnly
    ]] = AwsError.unwrapOptionField("inputAttachments", inputAttachments)
    def getInputSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.InputSpecification.ReadOnly
    ] = AwsError.unwrapOptionField("inputSpecification", inputSpecification)
    def getLogLevel: ZIO[Any, AwsError, zio.aws.medialive.model.LogLevel] =
      AwsError.unwrapOptionField("logLevel", logLevel)
    def getMaintenance: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.MaintenanceCreateSettings.ReadOnly
    ] = AwsError.unwrapOptionField("maintenance", maintenance)
    def getName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("name", name)
    def getRequestId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("requestId", requestId)
    def getReserved: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("reserved", reserved)
    def getRoleArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
    def getVpc: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.VpcOutputSettings.ReadOnly
    ] = AwsError.unwrapOptionField("vpc", vpc)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.CreateChannelRequest
  ) extends zio.aws.medialive.model.CreateChannelRequest.ReadOnly {
    override val cdiInputSpecification
        : Option[zio.aws.medialive.model.CdiInputSpecification.ReadOnly] = scala
      .Option(impl.cdiInputSpecification())
      .map(value => zio.aws.medialive.model.CdiInputSpecification.wrap(value))
    override val channelClass: Option[zio.aws.medialive.model.ChannelClass] =
      scala
        .Option(impl.channelClass())
        .map(value => zio.aws.medialive.model.ChannelClass.wrap(value))
    override val destinations
        : Option[List[zio.aws.medialive.model.OutputDestination.ReadOnly]] =
      scala
        .Option(impl.destinations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.medialive.model.OutputDestination.wrap(item)
          }.toList
        )
    override val encoderSettings
        : Option[zio.aws.medialive.model.EncoderSettings.ReadOnly] = scala
      .Option(impl.encoderSettings())
      .map(value => zio.aws.medialive.model.EncoderSettings.wrap(value))
    override val inputAttachments
        : Option[List[zio.aws.medialive.model.InputAttachment.ReadOnly]] = scala
      .Option(impl.inputAttachments())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.medialive.model.InputAttachment.wrap(item)
        }.toList
      )
    override val inputSpecification
        : Option[zio.aws.medialive.model.InputSpecification.ReadOnly] = scala
      .Option(impl.inputSpecification())
      .map(value => zio.aws.medialive.model.InputSpecification.wrap(value))
    override val logLevel: Option[zio.aws.medialive.model.LogLevel] = scala
      .Option(impl.logLevel())
      .map(value => zio.aws.medialive.model.LogLevel.wrap(value))
    override val maintenance
        : Option[zio.aws.medialive.model.MaintenanceCreateSettings.ReadOnly] =
      scala
        .Option(impl.maintenance())
        .map(value =>
          zio.aws.medialive.model.MaintenanceCreateSettings.wrap(value)
        )
    override val name: Option[__string] =
      scala.Option(impl.name()).map(value => value: __string)
    override val requestId: Option[__string] =
      scala.Option(impl.requestId()).map(value => value: __string)
    override val reserved: Option[__string] =
      scala.Option(impl.reserved()).map(value => value: __string)
    override val roleArn: Option[__string] =
      scala.Option(impl.roleArn()).map(value => value: __string)
    override val tags: Option[Map[__string, __string]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
    override val vpc
        : Option[zio.aws.medialive.model.VpcOutputSettings.ReadOnly] = scala
      .Option(impl.vpc())
      .map(value => zio.aws.medialive.model.VpcOutputSettings.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.CreateChannelRequest
  ): zio.aws.medialive.model.CreateChannelRequest.ReadOnly = new Wrapper(impl)
}
