package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class CreateInputRequest(
    destinations: Option[
      Iterable[zio.aws.medialive.model.InputDestinationRequest]
    ] = None,
    inputDevices: Option[
      Iterable[zio.aws.medialive.model.InputDeviceSettings]
    ] = None,
    inputSecurityGroups: Option[Iterable[__string]] = None,
    mediaConnectFlows: Option[
      Iterable[zio.aws.medialive.model.MediaConnectFlowRequest]
    ] = None,
    name: Option[__string] = None,
    requestId: Option[__string] = None,
    roleArn: Option[__string] = None,
    sources: Option[Iterable[zio.aws.medialive.model.InputSourceRequest]] =
      None,
    tags: Option[Map[__string, __string]] = None,
    `type`: Option[zio.aws.medialive.model.InputType] = None,
    vpc: Option[zio.aws.medialive.model.InputVpcRequest] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.CreateInputRequest = {
    import CreateInputRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.CreateInputRequest
      .builder()
      .optionallyWith(
        destinations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.destinations)
      .optionallyWith(
        inputDevices.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.inputDevices)
      .optionallyWith(
        inputSecurityGroups.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.inputSecurityGroups)
      .optionallyWith(
        mediaConnectFlows.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.mediaConnectFlows)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(requestId.map(value => value: java.lang.String))(
        _.requestId
      )
      .optionallyWith(roleArn.map(value => value: java.lang.String))(_.roleArn)
      .optionallyWith(
        sources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sources)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(vpc.map(value => value.buildAwsValue()))(_.vpc)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.CreateInputRequest.ReadOnly =
    zio.aws.medialive.model.CreateInputRequest.wrap(buildAwsValue())
}
object CreateInputRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.CreateInputRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.CreateInputRequest =
      zio.aws.medialive.model.CreateInputRequest(
        destinations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        inputDevices.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        inputSecurityGroups.map(value => value),
        mediaConnectFlows.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        name.map(value => value),
        requestId.map(value => value),
        roleArn.map(value => value),
        sources.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tags.map(value => value),
        `type`.map(value => value),
        vpc.map(value => value.asEditable)
      )
    def destinations
        : Option[List[zio.aws.medialive.model.InputDestinationRequest.ReadOnly]]
    def inputDevices
        : Option[List[zio.aws.medialive.model.InputDeviceSettings.ReadOnly]]
    def inputSecurityGroups: Option[List[__string]]
    def mediaConnectFlows
        : Option[List[zio.aws.medialive.model.MediaConnectFlowRequest.ReadOnly]]
    def name: Option[__string]
    def requestId: Option[__string]
    def roleArn: Option[__string]
    def sources
        : Option[List[zio.aws.medialive.model.InputSourceRequest.ReadOnly]]
    def tags: Option[Map[__string, __string]]
    def `type`: Option[zio.aws.medialive.model.InputType]
    def vpc: Option[zio.aws.medialive.model.InputVpcRequest.ReadOnly]
    def getDestinations: ZIO[Any, AwsError, List[
      zio.aws.medialive.model.InputDestinationRequest.ReadOnly
    ]] = AwsError.unwrapOptionField("destinations", destinations)
    def getInputDevices: ZIO[Any, AwsError, List[
      zio.aws.medialive.model.InputDeviceSettings.ReadOnly
    ]] = AwsError.unwrapOptionField("inputDevices", inputDevices)
    def getInputSecurityGroups: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("inputSecurityGroups", inputSecurityGroups)
    def getMediaConnectFlows: ZIO[Any, AwsError, List[
      zio.aws.medialive.model.MediaConnectFlowRequest.ReadOnly
    ]] = AwsError.unwrapOptionField("mediaConnectFlows", mediaConnectFlows)
    def getName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("name", name)
    def getRequestId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("requestId", requestId)
    def getRoleArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getSources: ZIO[Any, AwsError, List[
      zio.aws.medialive.model.InputSourceRequest.ReadOnly
    ]] = AwsError.unwrapOptionField("sources", sources)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
    def getType: ZIO[Any, AwsError, zio.aws.medialive.model.InputType] =
      AwsError.unwrapOptionField("type", `type`)
    def getVpc
        : ZIO[Any, AwsError, zio.aws.medialive.model.InputVpcRequest.ReadOnly] =
      AwsError.unwrapOptionField("vpc", vpc)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.CreateInputRequest
  ) extends zio.aws.medialive.model.CreateInputRequest.ReadOnly {
    override val destinations: Option[
      List[zio.aws.medialive.model.InputDestinationRequest.ReadOnly]
    ] = scala
      .Option(impl.destinations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.medialive.model.InputDestinationRequest.wrap(item)
        }.toList
      )
    override val inputDevices
        : Option[List[zio.aws.medialive.model.InputDeviceSettings.ReadOnly]] =
      scala
        .Option(impl.inputDevices())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.medialive.model.InputDeviceSettings.wrap(item)
          }.toList
        )
    override val inputSecurityGroups: Option[List[__string]] = scala
      .Option(impl.inputSecurityGroups())
      .map(value =>
        value.asScala.map { item =>
          item: __string
        }.toList
      )
    override val mediaConnectFlows: Option[
      List[zio.aws.medialive.model.MediaConnectFlowRequest.ReadOnly]
    ] = scala
      .Option(impl.mediaConnectFlows())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.medialive.model.MediaConnectFlowRequest.wrap(item)
        }.toList
      )
    override val name: Option[__string] =
      scala.Option(impl.name()).map(value => value: __string)
    override val requestId: Option[__string] =
      scala.Option(impl.requestId()).map(value => value: __string)
    override val roleArn: Option[__string] =
      scala.Option(impl.roleArn()).map(value => value: __string)
    override val sources
        : Option[List[zio.aws.medialive.model.InputSourceRequest.ReadOnly]] =
      scala
        .Option(impl.sources())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.medialive.model.InputSourceRequest.wrap(item)
          }.toList
        )
    override val tags: Option[Map[__string, __string]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
    override val `type`: Option[zio.aws.medialive.model.InputType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.medialive.model.InputType.wrap(value))
    override val vpc: Option[zio.aws.medialive.model.InputVpcRequest.ReadOnly] =
      scala
        .Option(impl.vpc())
        .map(value => zio.aws.medialive.model.InputVpcRequest.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.CreateInputRequest
  ): zio.aws.medialive.model.CreateInputRequest.ReadOnly = new Wrapper(impl)
}
