package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateInputResponse(
    input: Option[zio.aws.medialive.model.Input] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.CreateInputResponse = {
    import CreateInputResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.CreateInputResponse
      .builder()
      .optionallyWith(input.map(value => value.buildAwsValue()))(_.input)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.CreateInputResponse.ReadOnly =
    zio.aws.medialive.model.CreateInputResponse.wrap(buildAwsValue())
}
object CreateInputResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.CreateInputResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.CreateInputResponse =
      zio.aws.medialive.model
        .CreateInputResponse(input.map(value => value.asEditable))
    def input: Option[zio.aws.medialive.model.Input.ReadOnly]
    def getInput: ZIO[Any, AwsError, zio.aws.medialive.model.Input.ReadOnly] =
      AwsError.unwrapOptionField("input", input)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.CreateInputResponse
  ) extends zio.aws.medialive.model.CreateInputResponse.ReadOnly {
    override val input: Option[zio.aws.medialive.model.Input.ReadOnly] = scala
      .Option(impl.input())
      .map(value => zio.aws.medialive.model.Input.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.CreateInputResponse
  ): zio.aws.medialive.model.CreateInputResponse.ReadOnly = new Wrapper(impl)
}
