package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class CreateInputSecurityGroupRequest(
    tags: Option[Map[__string, __string]] = None,
    whitelistRules: Option[
      Iterable[zio.aws.medialive.model.InputWhitelistRuleCidr]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.CreateInputSecurityGroupRequest = {
    import CreateInputSecurityGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.CreateInputSecurityGroupRequest
      .builder()
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        whitelistRules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.whitelistRules)
      .build()
  }
  def asReadOnly
      : zio.aws.medialive.model.CreateInputSecurityGroupRequest.ReadOnly =
    zio.aws.medialive.model.CreateInputSecurityGroupRequest
      .wrap(buildAwsValue())
}
object CreateInputSecurityGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.CreateInputSecurityGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.CreateInputSecurityGroupRequest =
      zio.aws.medialive.model.CreateInputSecurityGroupRequest(
        tags.map(value => value),
        whitelistRules.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def tags: Option[Map[__string, __string]]
    def whitelistRules
        : Option[List[zio.aws.medialive.model.InputWhitelistRuleCidr.ReadOnly]]
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
    def getWhitelistRules: ZIO[Any, AwsError, List[
      zio.aws.medialive.model.InputWhitelistRuleCidr.ReadOnly
    ]] = AwsError.unwrapOptionField("whitelistRules", whitelistRules)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.CreateInputSecurityGroupRequest
  ) extends zio.aws.medialive.model.CreateInputSecurityGroupRequest.ReadOnly {
    override val tags: Option[Map[__string, __string]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
    override val whitelistRules: Option[
      List[zio.aws.medialive.model.InputWhitelistRuleCidr.ReadOnly]
    ] = scala
      .Option(impl.whitelistRules())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.medialive.model.InputWhitelistRuleCidr.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.CreateInputSecurityGroupRequest
  ): zio.aws.medialive.model.CreateInputSecurityGroupRequest.ReadOnly =
    new Wrapper(impl)
}
