package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateInputSecurityGroupResponse(
    securityGroup: Option[zio.aws.medialive.model.InputSecurityGroup] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.CreateInputSecurityGroupResponse = {
    import CreateInputSecurityGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.CreateInputSecurityGroupResponse
      .builder()
      .optionallyWith(securityGroup.map(value => value.buildAwsValue()))(
        _.securityGroup
      )
      .build()
  }
  def asReadOnly
      : zio.aws.medialive.model.CreateInputSecurityGroupResponse.ReadOnly =
    zio.aws.medialive.model.CreateInputSecurityGroupResponse
      .wrap(buildAwsValue())
}
object CreateInputSecurityGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.CreateInputSecurityGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.CreateInputSecurityGroupResponse =
      zio.aws.medialive.model.CreateInputSecurityGroupResponse(
        securityGroup.map(value => value.asEditable)
      )
    def securityGroup
        : Option[zio.aws.medialive.model.InputSecurityGroup.ReadOnly]
    def getSecurityGroup: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.InputSecurityGroup.ReadOnly
    ] = AwsError.unwrapOptionField("securityGroup", securityGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.CreateInputSecurityGroupResponse
  ) extends zio.aws.medialive.model.CreateInputSecurityGroupResponse.ReadOnly {
    override val securityGroup
        : Option[zio.aws.medialive.model.InputSecurityGroup.ReadOnly] = scala
      .Option(impl.securityGroup())
      .map(value => zio.aws.medialive.model.InputSecurityGroup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.CreateInputSecurityGroupResponse
  ): zio.aws.medialive.model.CreateInputSecurityGroupResponse.ReadOnly =
    new Wrapper(impl)
}
