package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.medialive.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class CreateMultiplexProgramRequest(
    multiplexId: __string,
    multiplexProgramSettings: zio.aws.medialive.model.MultiplexProgramSettings,
    programName: __string,
    requestId: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.CreateMultiplexProgramRequest = {
    import CreateMultiplexProgramRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.CreateMultiplexProgramRequest
      .builder()
      .multiplexId(multiplexId: java.lang.String)
      .multiplexProgramSettings(multiplexProgramSettings.buildAwsValue())
      .programName(programName: java.lang.String)
      .requestId(requestId: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.medialive.model.CreateMultiplexProgramRequest.ReadOnly =
    zio.aws.medialive.model.CreateMultiplexProgramRequest.wrap(buildAwsValue())
}
object CreateMultiplexProgramRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.CreateMultiplexProgramRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.CreateMultiplexProgramRequest =
      zio.aws.medialive.model.CreateMultiplexProgramRequest(
        multiplexId,
        multiplexProgramSettings.asEditable,
        programName,
        requestId
      )
    def multiplexId: __string
    def multiplexProgramSettings
        : zio.aws.medialive.model.MultiplexProgramSettings.ReadOnly
    def programName: __string
    def requestId: __string
    def getMultiplexId: ZIO[Any, Nothing, __string] = ZIO.succeed(multiplexId)
    def getMultiplexProgramSettings: ZIO[
      Any,
      Nothing,
      zio.aws.medialive.model.MultiplexProgramSettings.ReadOnly
    ] = ZIO.succeed(multiplexProgramSettings)
    def getProgramName: ZIO[Any, Nothing, __string] = ZIO.succeed(programName)
    def getRequestId: ZIO[Any, Nothing, __string] = ZIO.succeed(requestId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.CreateMultiplexProgramRequest
  ) extends zio.aws.medialive.model.CreateMultiplexProgramRequest.ReadOnly {
    override val multiplexId: __string = impl.multiplexId(): __string
    override val multiplexProgramSettings
        : zio.aws.medialive.model.MultiplexProgramSettings.ReadOnly =
      zio.aws.medialive.model.MultiplexProgramSettings
        .wrap(impl.multiplexProgramSettings())
    override val programName: __string = impl.programName(): __string
    override val requestId: __string = impl.requestId(): __string
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.CreateMultiplexProgramRequest
  ): zio.aws.medialive.model.CreateMultiplexProgramRequest.ReadOnly =
    new Wrapper(impl)
}
