package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateMultiplexProgramResponse(
    multiplexProgram: Option[zio.aws.medialive.model.MultiplexProgram] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.CreateMultiplexProgramResponse = {
    import CreateMultiplexProgramResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.CreateMultiplexProgramResponse
      .builder()
      .optionallyWith(multiplexProgram.map(value => value.buildAwsValue()))(
        _.multiplexProgram
      )
      .build()
  }
  def asReadOnly
      : zio.aws.medialive.model.CreateMultiplexProgramResponse.ReadOnly =
    zio.aws.medialive.model.CreateMultiplexProgramResponse.wrap(buildAwsValue())
}
object CreateMultiplexProgramResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.CreateMultiplexProgramResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.CreateMultiplexProgramResponse =
      zio.aws.medialive.model.CreateMultiplexProgramResponse(
        multiplexProgram.map(value => value.asEditable)
      )
    def multiplexProgram
        : Option[zio.aws.medialive.model.MultiplexProgram.ReadOnly]
    def getMultiplexProgram: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.MultiplexProgram.ReadOnly
    ] = AwsError.unwrapOptionField("multiplexProgram", multiplexProgram)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.CreateMultiplexProgramResponse
  ) extends zio.aws.medialive.model.CreateMultiplexProgramResponse.ReadOnly {
    override val multiplexProgram
        : Option[zio.aws.medialive.model.MultiplexProgram.ReadOnly] = scala
      .Option(impl.multiplexProgram())
      .map(value => zio.aws.medialive.model.MultiplexProgram.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.CreateMultiplexProgramResponse
  ): zio.aws.medialive.model.CreateMultiplexProgramResponse.ReadOnly =
    new Wrapper(impl)
}
