package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class CreateMultiplexRequest(
    availabilityZones: Iterable[__string],
    multiplexSettings: zio.aws.medialive.model.MultiplexSettings,
    name: __string,
    requestId: __string,
    tags: Option[Map[__string, __string]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.CreateMultiplexRequest = {
    import CreateMultiplexRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.CreateMultiplexRequest
      .builder()
      .availabilityZones(availabilityZones.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .multiplexSettings(multiplexSettings.buildAwsValue())
      .name(name: java.lang.String)
      .requestId(requestId: java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.CreateMultiplexRequest.ReadOnly =
    zio.aws.medialive.model.CreateMultiplexRequest.wrap(buildAwsValue())
}
object CreateMultiplexRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.CreateMultiplexRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.CreateMultiplexRequest =
      zio.aws.medialive.model.CreateMultiplexRequest(
        availabilityZones,
        multiplexSettings.asEditable,
        name,
        requestId,
        tags.map(value => value)
      )
    def availabilityZones: List[__string]
    def multiplexSettings: zio.aws.medialive.model.MultiplexSettings.ReadOnly
    def name: __string
    def requestId: __string
    def tags: Option[Map[__string, __string]]
    def getAvailabilityZones: ZIO[Any, Nothing, List[__string]] =
      ZIO.succeed(availabilityZones)
    def getMultiplexSettings: ZIO[
      Any,
      Nothing,
      zio.aws.medialive.model.MultiplexSettings.ReadOnly
    ] = ZIO.succeed(multiplexSettings)
    def getName: ZIO[Any, Nothing, __string] = ZIO.succeed(name)
    def getRequestId: ZIO[Any, Nothing, __string] = ZIO.succeed(requestId)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.CreateMultiplexRequest
  ) extends zio.aws.medialive.model.CreateMultiplexRequest.ReadOnly {
    override val availabilityZones: List[__string] = impl
      .availabilityZones()
      .asScala
      .map { item =>
        item: __string
      }
      .toList
    override val multiplexSettings
        : zio.aws.medialive.model.MultiplexSettings.ReadOnly =
      zio.aws.medialive.model.MultiplexSettings.wrap(impl.multiplexSettings())
    override val name: __string = impl.name(): __string
    override val requestId: __string = impl.requestId(): __string
    override val tags: Option[Map[__string, __string]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.CreateMultiplexRequest
  ): zio.aws.medialive.model.CreateMultiplexRequest.ReadOnly = new Wrapper(impl)
}
