package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateMultiplexResponse(
    multiplex: Option[zio.aws.medialive.model.Multiplex] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.CreateMultiplexResponse = {
    import CreateMultiplexResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.CreateMultiplexResponse
      .builder()
      .optionallyWith(multiplex.map(value => value.buildAwsValue()))(
        _.multiplex
      )
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.CreateMultiplexResponse.ReadOnly =
    zio.aws.medialive.model.CreateMultiplexResponse.wrap(buildAwsValue())
}
object CreateMultiplexResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.CreateMultiplexResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.CreateMultiplexResponse =
      zio.aws.medialive.model
        .CreateMultiplexResponse(multiplex.map(value => value.asEditable))
    def multiplex: Option[zio.aws.medialive.model.Multiplex.ReadOnly]
    def getMultiplex
        : ZIO[Any, AwsError, zio.aws.medialive.model.Multiplex.ReadOnly] =
      AwsError.unwrapOptionField("multiplex", multiplex)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.CreateMultiplexResponse
  ) extends zio.aws.medialive.model.CreateMultiplexResponse.ReadOnly {
    override val multiplex: Option[zio.aws.medialive.model.Multiplex.ReadOnly] =
      scala
        .Option(impl.multiplex())
        .map(value => zio.aws.medialive.model.Multiplex.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.CreateMultiplexResponse
  ): zio.aws.medialive.model.CreateMultiplexResponse.ReadOnly = new Wrapper(
    impl
  )
}
