package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class CreatePartnerInputRequest(
    inputId: __string,
    requestId: Option[__string] = None,
    tags: Option[Map[__string, __string]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.CreatePartnerInputRequest = {
    import CreatePartnerInputRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.CreatePartnerInputRequest
      .builder()
      .inputId(inputId: java.lang.String)
      .optionallyWith(requestId.map(value => value: java.lang.String))(
        _.requestId
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.CreatePartnerInputRequest.ReadOnly =
    zio.aws.medialive.model.CreatePartnerInputRequest.wrap(buildAwsValue())
}
object CreatePartnerInputRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.CreatePartnerInputRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.CreatePartnerInputRequest =
      zio.aws.medialive.model.CreatePartnerInputRequest(
        inputId,
        requestId.map(value => value),
        tags.map(value => value)
      )
    def inputId: __string
    def requestId: Option[__string]
    def tags: Option[Map[__string, __string]]
    def getInputId: ZIO[Any, Nothing, __string] = ZIO.succeed(inputId)
    def getRequestId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("requestId", requestId)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.CreatePartnerInputRequest
  ) extends zio.aws.medialive.model.CreatePartnerInputRequest.ReadOnly {
    override val inputId: __string = impl.inputId(): __string
    override val requestId: Option[__string] =
      scala.Option(impl.requestId()).map(value => value: __string)
    override val tags: Option[Map[__string, __string]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.CreatePartnerInputRequest
  ): zio.aws.medialive.model.CreatePartnerInputRequest.ReadOnly = new Wrapper(
    impl
  )
}
