package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreatePartnerInputResponse(
    input: Option[zio.aws.medialive.model.Input] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.CreatePartnerInputResponse = {
    import CreatePartnerInputResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.CreatePartnerInputResponse
      .builder()
      .optionallyWith(input.map(value => value.buildAwsValue()))(_.input)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.CreatePartnerInputResponse.ReadOnly =
    zio.aws.medialive.model.CreatePartnerInputResponse.wrap(buildAwsValue())
}
object CreatePartnerInputResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.CreatePartnerInputResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.CreatePartnerInputResponse =
      zio.aws.medialive.model
        .CreatePartnerInputResponse(input.map(value => value.asEditable))
    def input: Option[zio.aws.medialive.model.Input.ReadOnly]
    def getInput: ZIO[Any, AwsError, zio.aws.medialive.model.Input.ReadOnly] =
      AwsError.unwrapOptionField("input", input)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.CreatePartnerInputResponse
  ) extends zio.aws.medialive.model.CreatePartnerInputResponse.ReadOnly {
    override val input: Option[zio.aws.medialive.model.Input.ReadOnly] = scala
      .Option(impl.input())
      .map(value => zio.aws.medialive.model.Input.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.CreatePartnerInputResponse
  ): zio.aws.medialive.model.CreatePartnerInputResponse.ReadOnly = new Wrapper(
    impl
  )
}
