package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class CreateTagsRequest(
    resourceArn: __string,
    tags: Option[Map[__string, __string]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.CreateTagsRequest = {
    import CreateTagsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.CreateTagsRequest
      .builder()
      .resourceArn(resourceArn: java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.CreateTagsRequest.ReadOnly =
    zio.aws.medialive.model.CreateTagsRequest.wrap(buildAwsValue())
}
object CreateTagsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.CreateTagsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.CreateTagsRequest =
      zio.aws.medialive.model
        .CreateTagsRequest(resourceArn, tags.map(value => value))
    def resourceArn: __string
    def tags: Option[Map[__string, __string]]
    def getResourceArn: ZIO[Any, Nothing, __string] = ZIO.succeed(resourceArn)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.CreateTagsRequest
  ) extends zio.aws.medialive.model.CreateTagsRequest.ReadOnly {
    override val resourceArn: __string = impl.resourceArn(): __string
    override val tags: Option[Map[__string, __string]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.CreateTagsRequest
  ): zio.aws.medialive.model.CreateTagsRequest.ReadOnly = new Wrapper(impl)
}
