package zio.aws.medialive.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.{__integer, __string}
import scala.jdk.CollectionConverters._
final case class DeleteMultiplexResponse(
    arn: Option[__string] = None,
    availabilityZones: Option[Iterable[__string]] = None,
    destinations: Option[
      Iterable[zio.aws.medialive.model.MultiplexOutputDestination]
    ] = None,
    id: Option[__string] = None,
    multiplexSettings: Option[zio.aws.medialive.model.MultiplexSettings] = None,
    name: Option[__string] = None,
    pipelinesRunningCount: Option[__integer] = None,
    programCount: Option[__integer] = None,
    state: Option[zio.aws.medialive.model.MultiplexState] = None,
    tags: Option[Map[__string, __string]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.DeleteMultiplexResponse = {
    import DeleteMultiplexResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.DeleteMultiplexResponse
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(
        availabilityZones.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.availabilityZones)
      .optionallyWith(
        destinations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.destinations)
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(multiplexSettings.map(value => value.buildAwsValue()))(
        _.multiplexSettings
      )
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(pipelinesRunningCount.map(value => value: Integer))(
        _.pipelinesRunningCount
      )
      .optionallyWith(programCount.map(value => value: Integer))(_.programCount)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.DeleteMultiplexResponse.ReadOnly =
    zio.aws.medialive.model.DeleteMultiplexResponse.wrap(buildAwsValue())
}
object DeleteMultiplexResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.DeleteMultiplexResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.DeleteMultiplexResponse =
      zio.aws.medialive.model.DeleteMultiplexResponse(
        arn.map(value => value),
        availabilityZones.map(value => value),
        destinations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        id.map(value => value),
        multiplexSettings.map(value => value.asEditable),
        name.map(value => value),
        pipelinesRunningCount.map(value => value),
        programCount.map(value => value),
        state.map(value => value),
        tags.map(value => value)
      )
    def arn: Option[__string]
    def availabilityZones: Option[List[__string]]
    def destinations: Option[
      List[zio.aws.medialive.model.MultiplexOutputDestination.ReadOnly]
    ]
    def id: Option[__string]
    def multiplexSettings
        : Option[zio.aws.medialive.model.MultiplexSettings.ReadOnly]
    def name: Option[__string]
    def pipelinesRunningCount: Option[__integer]
    def programCount: Option[__integer]
    def state: Option[zio.aws.medialive.model.MultiplexState]
    def tags: Option[Map[__string, __string]]
    def getArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("arn", arn)
    def getAvailabilityZones: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("availabilityZones", availabilityZones)
    def getDestinations: ZIO[Any, AwsError, List[
      zio.aws.medialive.model.MultiplexOutputDestination.ReadOnly
    ]] = AwsError.unwrapOptionField("destinations", destinations)
    def getId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("id", id)
    def getMultiplexSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.MultiplexSettings.ReadOnly
    ] = AwsError.unwrapOptionField("multiplexSettings", multiplexSettings)
    def getName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("name", name)
    def getPipelinesRunningCount: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("pipelinesRunningCount", pipelinesRunningCount)
    def getProgramCount: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("programCount", programCount)
    def getState: ZIO[Any, AwsError, zio.aws.medialive.model.MultiplexState] =
      AwsError.unwrapOptionField("state", state)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.DeleteMultiplexResponse
  ) extends zio.aws.medialive.model.DeleteMultiplexResponse.ReadOnly {
    override val arn: Option[__string] =
      scala.Option(impl.arn()).map(value => value: __string)
    override val availabilityZones: Option[List[__string]] = scala
      .Option(impl.availabilityZones())
      .map(value =>
        value.asScala.map { item =>
          item: __string
        }.toList
      )
    override val destinations: Option[
      List[zio.aws.medialive.model.MultiplexOutputDestination.ReadOnly]
    ] = scala
      .Option(impl.destinations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.medialive.model.MultiplexOutputDestination.wrap(item)
        }.toList
      )
    override val id: Option[__string] =
      scala.Option(impl.id()).map(value => value: __string)
    override val multiplexSettings
        : Option[zio.aws.medialive.model.MultiplexSettings.ReadOnly] = scala
      .Option(impl.multiplexSettings())
      .map(value => zio.aws.medialive.model.MultiplexSettings.wrap(value))
    override val name: Option[__string] =
      scala.Option(impl.name()).map(value => value: __string)
    override val pipelinesRunningCount: Option[__integer] =
      scala.Option(impl.pipelinesRunningCount()).map(value => value: __integer)
    override val programCount: Option[__integer] =
      scala.Option(impl.programCount()).map(value => value: __integer)
    override val state: Option[zio.aws.medialive.model.MultiplexState] = scala
      .Option(impl.state())
      .map(value => zio.aws.medialive.model.MultiplexState.wrap(value))
    override val tags: Option[Map[__string, __string]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.DeleteMultiplexResponse
  ): zio.aws.medialive.model.DeleteMultiplexResponse.ReadOnly = new Wrapper(
    impl
  )
}
