package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.medialive.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class DeleteTagsRequest(
    resourceArn: __string,
    tagKeys: Iterable[__string]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.DeleteTagsRequest = {
    import DeleteTagsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.DeleteTagsRequest
      .builder()
      .resourceArn(resourceArn: java.lang.String)
      .tagKeys(tagKeys.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.DeleteTagsRequest.ReadOnly =
    zio.aws.medialive.model.DeleteTagsRequest.wrap(buildAwsValue())
}
object DeleteTagsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.DeleteTagsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.DeleteTagsRequest =
      zio.aws.medialive.model.DeleteTagsRequest(resourceArn, tagKeys)
    def resourceArn: __string
    def tagKeys: List[__string]
    def getResourceArn: ZIO[Any, Nothing, __string] = ZIO.succeed(resourceArn)
    def getTagKeys: ZIO[Any, Nothing, List[__string]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.DeleteTagsRequest
  ) extends zio.aws.medialive.model.DeleteTagsRequest.ReadOnly {
    override val resourceArn: __string = impl.resourceArn(): __string
    override val tagKeys: List[__string] = impl
      .tagKeys()
      .asScala
      .map { item =>
        item: __string
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.DeleteTagsRequest
  ): zio.aws.medialive.model.DeleteTagsRequest.ReadOnly = new Wrapper(impl)
}
