package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.medialive.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class DescribeInputDeviceThumbnailRequest(
    inputDeviceId: __string,
    accept: zio.aws.medialive.model.AcceptHeader
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.DescribeInputDeviceThumbnailRequest = {
    import DescribeInputDeviceThumbnailRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.DescribeInputDeviceThumbnailRequest
      .builder()
      .inputDeviceId(inputDeviceId: java.lang.String)
      .accept(accept.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.medialive.model.DescribeInputDeviceThumbnailRequest.ReadOnly =
    zio.aws.medialive.model.DescribeInputDeviceThumbnailRequest
      .wrap(buildAwsValue())
}
object DescribeInputDeviceThumbnailRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.DescribeInputDeviceThumbnailRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.medialive.model.DescribeInputDeviceThumbnailRequest =
      zio.aws.medialive.model
        .DescribeInputDeviceThumbnailRequest(inputDeviceId, accept)
    def inputDeviceId: __string
    def accept: zio.aws.medialive.model.AcceptHeader
    def getInputDeviceId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(inputDeviceId)
    def getAccept: ZIO[Any, Nothing, zio.aws.medialive.model.AcceptHeader] =
      ZIO.succeed(accept)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.DescribeInputDeviceThumbnailRequest
  ) extends zio.aws.medialive.model.DescribeInputDeviceThumbnailRequest.ReadOnly {
    override val inputDeviceId: __string = impl.inputDeviceId(): __string
    override val accept: zio.aws.medialive.model.AcceptHeader =
      zio.aws.medialive.model.AcceptHeader.wrap(impl.accept())
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.DescribeInputDeviceThumbnailRequest
  ): zio.aws.medialive.model.DescribeInputDeviceThumbnailRequest.ReadOnly =
    new Wrapper(impl)
}
