package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.{__timestamp, __string, __long}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class DescribeInputDeviceThumbnailResponse(
    contentType: Option[zio.aws.medialive.model.ContentType] = None,
    contentLength: Option[__long] = None,
    eTag: Option[__string] = None,
    lastModified: Option[__timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.DescribeInputDeviceThumbnailResponse = {
    import DescribeInputDeviceThumbnailResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.DescribeInputDeviceThumbnailResponse
      .builder()
      .optionallyWith(contentType.map(value => value.unwrap))(_.contentType)
      .optionallyWith(contentLength.map(value => value: java.lang.Long))(
        _.contentLength
      )
      .optionallyWith(eTag.map(value => value: java.lang.String))(_.eTag)
      .optionallyWith(lastModified.map(value => value: Instant))(_.lastModified)
      .build()
  }
  def asReadOnly
      : zio.aws.medialive.model.DescribeInputDeviceThumbnailResponse.ReadOnly =
    zio.aws.medialive.model.DescribeInputDeviceThumbnailResponse
      .wrap(buildAwsValue())
}
object DescribeInputDeviceThumbnailResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.DescribeInputDeviceThumbnailResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.medialive.model.DescribeInputDeviceThumbnailResponse =
      zio.aws.medialive.model.DescribeInputDeviceThumbnailResponse(
        contentType.map(value => value),
        contentLength.map(value => value),
        eTag.map(value => value),
        lastModified.map(value => value)
      )
    def contentType: Option[zio.aws.medialive.model.ContentType]
    def contentLength: Option[__long]
    def eTag: Option[__string]
    def lastModified: Option[__timestamp]
    def getContentType
        : ZIO[Any, AwsError, zio.aws.medialive.model.ContentType] =
      AwsError.unwrapOptionField("contentType", contentType)
    def getContentLength: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("contentLength", contentLength)
    def getETag: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("eTag", eTag)
    def getLastModified: ZIO[Any, AwsError, __timestamp] =
      AwsError.unwrapOptionField("lastModified", lastModified)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.DescribeInputDeviceThumbnailResponse
  ) extends zio.aws.medialive.model.DescribeInputDeviceThumbnailResponse.ReadOnly {
    override val contentType: Option[zio.aws.medialive.model.ContentType] =
      scala
        .Option(impl.contentType())
        .map(value => zio.aws.medialive.model.ContentType.wrap(value))
    override val contentLength: Option[__long] =
      scala.Option(impl.contentLength()).map(value => value: __long)
    override val eTag: Option[__string] =
      scala.Option(impl.eTag()).map(value => value: __string)
    override val lastModified: Option[__timestamp] =
      scala.Option(impl.lastModified()).map(value => value: __timestamp)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.DescribeInputDeviceThumbnailResponse
  ): zio.aws.medialive.model.DescribeInputDeviceThumbnailResponse.ReadOnly =
    new Wrapper(impl)
}
