package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class DescribeInputSecurityGroupResponse(
    arn: Option[__string] = None,
    id: Option[__string] = None,
    inputs: Option[Iterable[__string]] = None,
    state: Option[zio.aws.medialive.model.InputSecurityGroupState] = None,
    tags: Option[Map[__string, __string]] = None,
    whitelistRules: Option[
      Iterable[zio.aws.medialive.model.InputWhitelistRule]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.DescribeInputSecurityGroupResponse = {
    import DescribeInputSecurityGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.DescribeInputSecurityGroupResponse
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(
        inputs.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.inputs)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        whitelistRules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.whitelistRules)
      .build()
  }
  def asReadOnly
      : zio.aws.medialive.model.DescribeInputSecurityGroupResponse.ReadOnly =
    zio.aws.medialive.model.DescribeInputSecurityGroupResponse
      .wrap(buildAwsValue())
}
object DescribeInputSecurityGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.DescribeInputSecurityGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.DescribeInputSecurityGroupResponse =
      zio.aws.medialive.model.DescribeInputSecurityGroupResponse(
        arn.map(value => value),
        id.map(value => value),
        inputs.map(value => value),
        state.map(value => value),
        tags.map(value => value),
        whitelistRules.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def arn: Option[__string]
    def id: Option[__string]
    def inputs: Option[List[__string]]
    def state: Option[zio.aws.medialive.model.InputSecurityGroupState]
    def tags: Option[Map[__string, __string]]
    def whitelistRules
        : Option[List[zio.aws.medialive.model.InputWhitelistRule.ReadOnly]]
    def getArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("arn", arn)
    def getId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("id", id)
    def getInputs: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("inputs", inputs)
    def getState
        : ZIO[Any, AwsError, zio.aws.medialive.model.InputSecurityGroupState] =
      AwsError.unwrapOptionField("state", state)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
    def getWhitelistRules: ZIO[Any, AwsError, List[
      zio.aws.medialive.model.InputWhitelistRule.ReadOnly
    ]] = AwsError.unwrapOptionField("whitelistRules", whitelistRules)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.DescribeInputSecurityGroupResponse
  ) extends zio.aws.medialive.model.DescribeInputSecurityGroupResponse.ReadOnly {
    override val arn: Option[__string] =
      scala.Option(impl.arn()).map(value => value: __string)
    override val id: Option[__string] =
      scala.Option(impl.id()).map(value => value: __string)
    override val inputs: Option[List[__string]] = scala
      .Option(impl.inputs())
      .map(value =>
        value.asScala.map { item =>
          item: __string
        }.toList
      )
    override val state
        : Option[zio.aws.medialive.model.InputSecurityGroupState] = scala
      .Option(impl.state())
      .map(value => zio.aws.medialive.model.InputSecurityGroupState.wrap(value))
    override val tags: Option[Map[__string, __string]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
    override val whitelistRules
        : Option[List[zio.aws.medialive.model.InputWhitelistRule.ReadOnly]] =
      scala
        .Option(impl.whitelistRules())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.medialive.model.InputWhitelistRule.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.DescribeInputSecurityGroupResponse
  ): zio.aws.medialive.model.DescribeInputSecurityGroupResponse.ReadOnly =
    new Wrapper(impl)
}
