package zio.aws.medialive.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.{__double, __integer, __string}
import scala.jdk.CollectionConverters._
final case class DescribeOfferingResponse(
    arn: Option[__string] = None,
    currencyCode: Option[__string] = None,
    duration: Option[__integer] = None,
    durationUnits: Option[zio.aws.medialive.model.OfferingDurationUnits] = None,
    fixedPrice: Option[__double] = None,
    offeringDescription: Option[__string] = None,
    offeringId: Option[__string] = None,
    offeringType: Option[zio.aws.medialive.model.OfferingType] = None,
    region: Option[__string] = None,
    resourceSpecification: Option[
      zio.aws.medialive.model.ReservationResourceSpecification
    ] = None,
    usagePrice: Option[__double] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.DescribeOfferingResponse = {
    import DescribeOfferingResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.DescribeOfferingResponse
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(currencyCode.map(value => value: java.lang.String))(
        _.currencyCode
      )
      .optionallyWith(duration.map(value => value: Integer))(_.duration)
      .optionallyWith(durationUnits.map(value => value.unwrap))(_.durationUnits)
      .optionallyWith(fixedPrice.map(value => value: java.lang.Double))(
        _.fixedPrice
      )
      .optionallyWith(
        offeringDescription.map(value => value: java.lang.String)
      )(_.offeringDescription)
      .optionallyWith(offeringId.map(value => value: java.lang.String))(
        _.offeringId
      )
      .optionallyWith(offeringType.map(value => value.unwrap))(_.offeringType)
      .optionallyWith(region.map(value => value: java.lang.String))(_.region)
      .optionallyWith(
        resourceSpecification.map(value => value.buildAwsValue())
      )(_.resourceSpecification)
      .optionallyWith(usagePrice.map(value => value: java.lang.Double))(
        _.usagePrice
      )
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.DescribeOfferingResponse.ReadOnly =
    zio.aws.medialive.model.DescribeOfferingResponse.wrap(buildAwsValue())
}
object DescribeOfferingResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.DescribeOfferingResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.DescribeOfferingResponse =
      zio.aws.medialive.model.DescribeOfferingResponse(
        arn.map(value => value),
        currencyCode.map(value => value),
        duration.map(value => value),
        durationUnits.map(value => value),
        fixedPrice.map(value => value),
        offeringDescription.map(value => value),
        offeringId.map(value => value),
        offeringType.map(value => value),
        region.map(value => value),
        resourceSpecification.map(value => value.asEditable),
        usagePrice.map(value => value)
      )
    def arn: Option[__string]
    def currencyCode: Option[__string]
    def duration: Option[__integer]
    def durationUnits: Option[zio.aws.medialive.model.OfferingDurationUnits]
    def fixedPrice: Option[__double]
    def offeringDescription: Option[__string]
    def offeringId: Option[__string]
    def offeringType: Option[zio.aws.medialive.model.OfferingType]
    def region: Option[__string]
    def resourceSpecification: Option[
      zio.aws.medialive.model.ReservationResourceSpecification.ReadOnly
    ]
    def usagePrice: Option[__double]
    def getArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("arn", arn)
    def getCurrencyCode: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("currencyCode", currencyCode)
    def getDuration: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("duration", duration)
    def getDurationUnits
        : ZIO[Any, AwsError, zio.aws.medialive.model.OfferingDurationUnits] =
      AwsError.unwrapOptionField("durationUnits", durationUnits)
    def getFixedPrice: ZIO[Any, AwsError, __double] =
      AwsError.unwrapOptionField("fixedPrice", fixedPrice)
    def getOfferingDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("offeringDescription", offeringDescription)
    def getOfferingId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("offeringId", offeringId)
    def getOfferingType
        : ZIO[Any, AwsError, zio.aws.medialive.model.OfferingType] =
      AwsError.unwrapOptionField("offeringType", offeringType)
    def getRegion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("region", region)
    def getResourceSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.ReservationResourceSpecification.ReadOnly
    ] =
      AwsError.unwrapOptionField("resourceSpecification", resourceSpecification)
    def getUsagePrice: ZIO[Any, AwsError, __double] =
      AwsError.unwrapOptionField("usagePrice", usagePrice)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.DescribeOfferingResponse
  ) extends zio.aws.medialive.model.DescribeOfferingResponse.ReadOnly {
    override val arn: Option[__string] =
      scala.Option(impl.arn()).map(value => value: __string)
    override val currencyCode: Option[__string] =
      scala.Option(impl.currencyCode()).map(value => value: __string)
    override val duration: Option[__integer] =
      scala.Option(impl.duration()).map(value => value: __integer)
    override val durationUnits
        : Option[zio.aws.medialive.model.OfferingDurationUnits] = scala
      .Option(impl.durationUnits())
      .map(value => zio.aws.medialive.model.OfferingDurationUnits.wrap(value))
    override val fixedPrice: Option[__double] =
      scala.Option(impl.fixedPrice()).map(value => value: __double)
    override val offeringDescription: Option[__string] =
      scala.Option(impl.offeringDescription()).map(value => value: __string)
    override val offeringId: Option[__string] =
      scala.Option(impl.offeringId()).map(value => value: __string)
    override val offeringType: Option[zio.aws.medialive.model.OfferingType] =
      scala
        .Option(impl.offeringType())
        .map(value => zio.aws.medialive.model.OfferingType.wrap(value))
    override val region: Option[__string] =
      scala.Option(impl.region()).map(value => value: __string)
    override val resourceSpecification: Option[
      zio.aws.medialive.model.ReservationResourceSpecification.ReadOnly
    ] = scala
      .Option(impl.resourceSpecification())
      .map(value =>
        zio.aws.medialive.model.ReservationResourceSpecification.wrap(value)
      )
    override val usagePrice: Option[__double] =
      scala.Option(impl.usagePrice()).map(value => value: __double)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.DescribeOfferingResponse
  ): zio.aws.medialive.model.DescribeOfferingResponse.ReadOnly = new Wrapper(
    impl
  )
}
