package zio.aws.medialive.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.{__double, __integer, __string}
import scala.jdk.CollectionConverters._
final case class DescribeReservationResponse(
    arn: Option[__string] = None,
    count: Option[__integer] = None,
    currencyCode: Option[__string] = None,
    duration: Option[__integer] = None,
    durationUnits: Option[zio.aws.medialive.model.OfferingDurationUnits] = None,
    end: Option[__string] = None,
    fixedPrice: Option[__double] = None,
    name: Option[__string] = None,
    offeringDescription: Option[__string] = None,
    offeringId: Option[__string] = None,
    offeringType: Option[zio.aws.medialive.model.OfferingType] = None,
    region: Option[__string] = None,
    reservationId: Option[__string] = None,
    resourceSpecification: Option[
      zio.aws.medialive.model.ReservationResourceSpecification
    ] = None,
    start: Option[__string] = None,
    state: Option[zio.aws.medialive.model.ReservationState] = None,
    tags: Option[Map[__string, __string]] = None,
    usagePrice: Option[__double] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.DescribeReservationResponse = {
    import DescribeReservationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.DescribeReservationResponse
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(count.map(value => value: Integer))(_.count)
      .optionallyWith(currencyCode.map(value => value: java.lang.String))(
        _.currencyCode
      )
      .optionallyWith(duration.map(value => value: Integer))(_.duration)
      .optionallyWith(durationUnits.map(value => value.unwrap))(_.durationUnits)
      .optionallyWith(end.map(value => value: java.lang.String))(_.end)
      .optionallyWith(fixedPrice.map(value => value: java.lang.Double))(
        _.fixedPrice
      )
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(
        offeringDescription.map(value => value: java.lang.String)
      )(_.offeringDescription)
      .optionallyWith(offeringId.map(value => value: java.lang.String))(
        _.offeringId
      )
      .optionallyWith(offeringType.map(value => value.unwrap))(_.offeringType)
      .optionallyWith(region.map(value => value: java.lang.String))(_.region)
      .optionallyWith(reservationId.map(value => value: java.lang.String))(
        _.reservationId
      )
      .optionallyWith(
        resourceSpecification.map(value => value.buildAwsValue())
      )(_.resourceSpecification)
      .optionallyWith(start.map(value => value: java.lang.String))(_.start)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(usagePrice.map(value => value: java.lang.Double))(
        _.usagePrice
      )
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.DescribeReservationResponse.ReadOnly =
    zio.aws.medialive.model.DescribeReservationResponse.wrap(buildAwsValue())
}
object DescribeReservationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.DescribeReservationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.DescribeReservationResponse =
      zio.aws.medialive.model.DescribeReservationResponse(
        arn.map(value => value),
        count.map(value => value),
        currencyCode.map(value => value),
        duration.map(value => value),
        durationUnits.map(value => value),
        end.map(value => value),
        fixedPrice.map(value => value),
        name.map(value => value),
        offeringDescription.map(value => value),
        offeringId.map(value => value),
        offeringType.map(value => value),
        region.map(value => value),
        reservationId.map(value => value),
        resourceSpecification.map(value => value.asEditable),
        start.map(value => value),
        state.map(value => value),
        tags.map(value => value),
        usagePrice.map(value => value)
      )
    def arn: Option[__string]
    def count: Option[__integer]
    def currencyCode: Option[__string]
    def duration: Option[__integer]
    def durationUnits: Option[zio.aws.medialive.model.OfferingDurationUnits]
    def end: Option[__string]
    def fixedPrice: Option[__double]
    def name: Option[__string]
    def offeringDescription: Option[__string]
    def offeringId: Option[__string]
    def offeringType: Option[zio.aws.medialive.model.OfferingType]
    def region: Option[__string]
    def reservationId: Option[__string]
    def resourceSpecification: Option[
      zio.aws.medialive.model.ReservationResourceSpecification.ReadOnly
    ]
    def start: Option[__string]
    def state: Option[zio.aws.medialive.model.ReservationState]
    def tags: Option[Map[__string, __string]]
    def usagePrice: Option[__double]
    def getArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("arn", arn)
    def getCount: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("count", count)
    def getCurrencyCode: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("currencyCode", currencyCode)
    def getDuration: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("duration", duration)
    def getDurationUnits
        : ZIO[Any, AwsError, zio.aws.medialive.model.OfferingDurationUnits] =
      AwsError.unwrapOptionField("durationUnits", durationUnits)
    def getEnd: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("end", end)
    def getFixedPrice: ZIO[Any, AwsError, __double] =
      AwsError.unwrapOptionField("fixedPrice", fixedPrice)
    def getName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("name", name)
    def getOfferingDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("offeringDescription", offeringDescription)
    def getOfferingId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("offeringId", offeringId)
    def getOfferingType
        : ZIO[Any, AwsError, zio.aws.medialive.model.OfferingType] =
      AwsError.unwrapOptionField("offeringType", offeringType)
    def getRegion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("region", region)
    def getReservationId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("reservationId", reservationId)
    def getResourceSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.ReservationResourceSpecification.ReadOnly
    ] =
      AwsError.unwrapOptionField("resourceSpecification", resourceSpecification)
    def getStart: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("start", start)
    def getState: ZIO[Any, AwsError, zio.aws.medialive.model.ReservationState] =
      AwsError.unwrapOptionField("state", state)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
    def getUsagePrice: ZIO[Any, AwsError, __double] =
      AwsError.unwrapOptionField("usagePrice", usagePrice)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.DescribeReservationResponse
  ) extends zio.aws.medialive.model.DescribeReservationResponse.ReadOnly {
    override val arn: Option[__string] =
      scala.Option(impl.arn()).map(value => value: __string)
    override val count: Option[__integer] =
      scala.Option(impl.count()).map(value => value: __integer)
    override val currencyCode: Option[__string] =
      scala.Option(impl.currencyCode()).map(value => value: __string)
    override val duration: Option[__integer] =
      scala.Option(impl.duration()).map(value => value: __integer)
    override val durationUnits
        : Option[zio.aws.medialive.model.OfferingDurationUnits] = scala
      .Option(impl.durationUnits())
      .map(value => zio.aws.medialive.model.OfferingDurationUnits.wrap(value))
    override val end: Option[__string] =
      scala.Option(impl.end()).map(value => value: __string)
    override val fixedPrice: Option[__double] =
      scala.Option(impl.fixedPrice()).map(value => value: __double)
    override val name: Option[__string] =
      scala.Option(impl.name()).map(value => value: __string)
    override val offeringDescription: Option[__string] =
      scala.Option(impl.offeringDescription()).map(value => value: __string)
    override val offeringId: Option[__string] =
      scala.Option(impl.offeringId()).map(value => value: __string)
    override val offeringType: Option[zio.aws.medialive.model.OfferingType] =
      scala
        .Option(impl.offeringType())
        .map(value => zio.aws.medialive.model.OfferingType.wrap(value))
    override val region: Option[__string] =
      scala.Option(impl.region()).map(value => value: __string)
    override val reservationId: Option[__string] =
      scala.Option(impl.reservationId()).map(value => value: __string)
    override val resourceSpecification: Option[
      zio.aws.medialive.model.ReservationResourceSpecification.ReadOnly
    ] = scala
      .Option(impl.resourceSpecification())
      .map(value =>
        zio.aws.medialive.model.ReservationResourceSpecification.wrap(value)
      )
    override val start: Option[__string] =
      scala.Option(impl.start()).map(value => value: __string)
    override val state: Option[zio.aws.medialive.model.ReservationState] = scala
      .Option(impl.state())
      .map(value => zio.aws.medialive.model.ReservationState.wrap(value))
    override val tags: Option[Map[__string, __string]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
    override val usagePrice: Option[__double] =
      scala.Option(impl.usagePrice()).map(value => value: __double)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.DescribeReservationResponse
  ): zio.aws.medialive.model.DescribeReservationResponse.ReadOnly = new Wrapper(
    impl
  )
}
