package zio.aws.medialive.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.{MaxResults, __string}
import scala.jdk.CollectionConverters._
final case class DescribeScheduleRequest(
    channelId: __string,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.DescribeScheduleRequest = {
    import DescribeScheduleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.DescribeScheduleRequest
      .builder()
      .channelId(channelId: java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.DescribeScheduleRequest.ReadOnly =
    zio.aws.medialive.model.DescribeScheduleRequest.wrap(buildAwsValue())
}
object DescribeScheduleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.DescribeScheduleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.DescribeScheduleRequest =
      zio.aws.medialive.model.DescribeScheduleRequest(
        channelId,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def channelId: __string
    def maxResults: Option[MaxResults]
    def nextToken: Option[__string]
    def getChannelId: ZIO[Any, Nothing, __string] = ZIO.succeed(channelId)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.DescribeScheduleRequest
  ) extends zio.aws.medialive.model.DescribeScheduleRequest.ReadOnly {
    override val channelId: __string = impl.channelId(): __string
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.medialive.model.primitives.MaxResults(value))
    override val nextToken: Option[__string] =
      scala.Option(impl.nextToken()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.DescribeScheduleRequest
  ): zio.aws.medialive.model.DescribeScheduleRequest.ReadOnly = new Wrapper(
    impl
  )
}
