package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class DescribeScheduleResponse(
    nextToken: Option[__string] = None,
    scheduleActions: Option[Iterable[zio.aws.medialive.model.ScheduleAction]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.DescribeScheduleResponse = {
    import DescribeScheduleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.DescribeScheduleResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        scheduleActions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.scheduleActions)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.DescribeScheduleResponse.ReadOnly =
    zio.aws.medialive.model.DescribeScheduleResponse.wrap(buildAwsValue())
}
object DescribeScheduleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.DescribeScheduleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.DescribeScheduleResponse =
      zio.aws.medialive.model.DescribeScheduleResponse(
        nextToken.map(value => value),
        scheduleActions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[__string]
    def scheduleActions
        : Option[List[zio.aws.medialive.model.ScheduleAction.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getScheduleActions: ZIO[Any, AwsError, List[
      zio.aws.medialive.model.ScheduleAction.ReadOnly
    ]] = AwsError.unwrapOptionField("scheduleActions", scheduleActions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.DescribeScheduleResponse
  ) extends zio.aws.medialive.model.DescribeScheduleResponse.ReadOnly {
    override val nextToken: Option[__string] =
      scala.Option(impl.nextToken()).map(value => value: __string)
    override val scheduleActions
        : Option[List[zio.aws.medialive.model.ScheduleAction.ReadOnly]] = scala
      .Option(impl.scheduleActions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.medialive.model.ScheduleAction.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.DescribeScheduleResponse
  ): zio.aws.medialive.model.DescribeScheduleResponse.ReadOnly = new Wrapper(
    impl
  )
}
