package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait DeviceSettingsSyncState {
  def unwrap
      : software.amazon.awssdk.services.medialive.model.DeviceSettingsSyncState
}
object DeviceSettingsSyncState {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.DeviceSettingsSyncState
  ): zio.aws.medialive.model.DeviceSettingsSyncState = value match {
    case software.amazon.awssdk.services.medialive.model.DeviceSettingsSyncState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.DeviceSettingsSyncState.SYNCED =>
      val r = SYNCED
      r
    case software.amazon.awssdk.services.medialive.model.DeviceSettingsSyncState.SYNCING =>
      val r = SYNCING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.DeviceSettingsSyncState {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.DeviceSettingsSyncState =
      software.amazon.awssdk.services.medialive.model.DeviceSettingsSyncState.UNKNOWN_TO_SDK_VERSION
  }
  case object SYNCED extends zio.aws.medialive.model.DeviceSettingsSyncState {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.DeviceSettingsSyncState =
      software.amazon.awssdk.services.medialive.model.DeviceSettingsSyncState.SYNCED
  }
  case object SYNCING extends zio.aws.medialive.model.DeviceSettingsSyncState {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.DeviceSettingsSyncState =
      software.amazon.awssdk.services.medialive.model.DeviceSettingsSyncState.SYNCING
  }
}
