package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait DeviceUpdateStatus {
  def unwrap: software.amazon.awssdk.services.medialive.model.DeviceUpdateStatus
}
object DeviceUpdateStatus {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.DeviceUpdateStatus
  ): zio.aws.medialive.model.DeviceUpdateStatus = value match {
    case software.amazon.awssdk.services.medialive.model.DeviceUpdateStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.DeviceUpdateStatus.UP_TO_DATE =>
      val r = UP_TO_DATE
      r
    case software.amazon.awssdk.services.medialive.model.DeviceUpdateStatus.NOT_UP_TO_DATE =>
      val r = NOT_UP_TO_DATE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.DeviceUpdateStatus {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.DeviceUpdateStatus =
      software.amazon.awssdk.services.medialive.model.DeviceUpdateStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object UP_TO_DATE extends zio.aws.medialive.model.DeviceUpdateStatus {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.DeviceUpdateStatus =
      software.amazon.awssdk.services.medialive.model.DeviceUpdateStatus.UP_TO_DATE
  }
  case object NOT_UP_TO_DATE
      extends zio.aws.medialive.model.DeviceUpdateStatus {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.DeviceUpdateStatus =
      software.amazon.awssdk.services.medialive.model.DeviceUpdateStatus.NOT_UP_TO_DATE
  }
}
