package zio.aws.medialive.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.{
  __integerMin25Max10000,
  __stringMin1Max256,
  __integerMin0Max65536
}
import scala.jdk.CollectionConverters._
final case class DvbNitSettings(
    networkId: __integerMin0Max65536,
    networkName: __stringMin1Max256,
    repInterval: Option[__integerMin25Max10000] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.DvbNitSettings = {
    import DvbNitSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.DvbNitSettings
      .builder()
      .networkId(networkId: Integer)
      .networkName(networkName: java.lang.String)
      .optionallyWith(repInterval.map(value => value: Integer))(_.repInterval)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.DvbNitSettings.ReadOnly =
    zio.aws.medialive.model.DvbNitSettings.wrap(buildAwsValue())
}
object DvbNitSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.DvbNitSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.DvbNitSettings =
      zio.aws.medialive.model
        .DvbNitSettings(networkId, networkName, repInterval.map(value => value))
    def networkId: __integerMin0Max65536
    def networkName: __stringMin1Max256
    def repInterval: Option[__integerMin25Max10000]
    def getNetworkId: ZIO[Any, Nothing, __integerMin0Max65536] =
      ZIO.succeed(networkId)
    def getNetworkName: ZIO[Any, Nothing, __stringMin1Max256] =
      ZIO.succeed(networkName)
    def getRepInterval: ZIO[Any, AwsError, __integerMin25Max10000] =
      AwsError.unwrapOptionField("repInterval", repInterval)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.DvbNitSettings
  ) extends zio.aws.medialive.model.DvbNitSettings.ReadOnly {
    override val networkId: __integerMin0Max65536 =
      impl.networkId(): __integerMin0Max65536
    override val networkName: __stringMin1Max256 =
      impl.networkName(): __stringMin1Max256
    override val repInterval: Option[__integerMin25Max10000] = scala
      .Option(impl.repInterval())
      .map(value => value: __integerMin25Max10000)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.DvbNitSettings
  ): zio.aws.medialive.model.DvbNitSettings.ReadOnly = new Wrapper(impl)
}
