package zio.aws.medialive.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.{
  __stringMin1Max256,
  __integerMin25Max2000
}
import scala.jdk.CollectionConverters._
final case class DvbSdtSettings(
    outputSdt: Option[zio.aws.medialive.model.DvbSdtOutputSdt] = None,
    repInterval: Option[__integerMin25Max2000] = None,
    serviceName: Option[__stringMin1Max256] = None,
    serviceProviderName: Option[__stringMin1Max256] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.DvbSdtSettings = {
    import DvbSdtSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.DvbSdtSettings
      .builder()
      .optionallyWith(outputSdt.map(value => value.unwrap))(_.outputSdt)
      .optionallyWith(repInterval.map(value => value: Integer))(_.repInterval)
      .optionallyWith(serviceName.map(value => value: java.lang.String))(
        _.serviceName
      )
      .optionallyWith(
        serviceProviderName.map(value => value: java.lang.String)
      )(_.serviceProviderName)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.DvbSdtSettings.ReadOnly =
    zio.aws.medialive.model.DvbSdtSettings.wrap(buildAwsValue())
}
object DvbSdtSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.DvbSdtSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.DvbSdtSettings =
      zio.aws.medialive.model.DvbSdtSettings(
        outputSdt.map(value => value),
        repInterval.map(value => value),
        serviceName.map(value => value),
        serviceProviderName.map(value => value)
      )
    def outputSdt: Option[zio.aws.medialive.model.DvbSdtOutputSdt]
    def repInterval: Option[__integerMin25Max2000]
    def serviceName: Option[__stringMin1Max256]
    def serviceProviderName: Option[__stringMin1Max256]
    def getOutputSdt
        : ZIO[Any, AwsError, zio.aws.medialive.model.DvbSdtOutputSdt] =
      AwsError.unwrapOptionField("outputSdt", outputSdt)
    def getRepInterval: ZIO[Any, AwsError, __integerMin25Max2000] =
      AwsError.unwrapOptionField("repInterval", repInterval)
    def getServiceName: ZIO[Any, AwsError, __stringMin1Max256] =
      AwsError.unwrapOptionField("serviceName", serviceName)
    def getServiceProviderName: ZIO[Any, AwsError, __stringMin1Max256] =
      AwsError.unwrapOptionField("serviceProviderName", serviceProviderName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.DvbSdtSettings
  ) extends zio.aws.medialive.model.DvbSdtSettings.ReadOnly {
    override val outputSdt: Option[zio.aws.medialive.model.DvbSdtOutputSdt] =
      scala
        .Option(impl.outputSdt())
        .map(value => zio.aws.medialive.model.DvbSdtOutputSdt.wrap(value))
    override val repInterval: Option[__integerMin25Max2000] = scala
      .Option(impl.repInterval())
      .map(value => value: __integerMin25Max2000)
    override val serviceName: Option[__stringMin1Max256] =
      scala.Option(impl.serviceName()).map(value => value: __stringMin1Max256)
    override val serviceProviderName: Option[__stringMin1Max256] = scala
      .Option(impl.serviceProviderName())
      .map(value => value: __stringMin1Max256)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.DvbSdtSettings
  ): zio.aws.medialive.model.DvbSdtSettings.ReadOnly = new Wrapper(impl)
}
