package zio.aws.medialive.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.{
  __integerMin0,
  __string,
  __integer,
  __integerMin0Max10,
  __integerMin0Max255,
  __integerMin96Max600
}
import scala.jdk.CollectionConverters._
final case class DvbSubDestinationSettings(
    alignment: Option[zio.aws.medialive.model.DvbSubDestinationAlignment] =
      None,
    backgroundColor: Option[
      zio.aws.medialive.model.DvbSubDestinationBackgroundColor
    ] = None,
    backgroundOpacity: Option[__integerMin0Max255] = None,
    font: Option[zio.aws.medialive.model.InputLocation] = None,
    fontColor: Option[zio.aws.medialive.model.DvbSubDestinationFontColor] =
      None,
    fontOpacity: Option[__integerMin0Max255] = None,
    fontResolution: Option[__integerMin96Max600] = None,
    fontSize: Option[__string] = None,
    outlineColor: Option[
      zio.aws.medialive.model.DvbSubDestinationOutlineColor
    ] = None,
    outlineSize: Option[__integerMin0Max10] = None,
    shadowColor: Option[zio.aws.medialive.model.DvbSubDestinationShadowColor] =
      None,
    shadowOpacity: Option[__integerMin0Max255] = None,
    shadowXOffset: Option[__integer] = None,
    shadowYOffset: Option[__integer] = None,
    teletextGridControl: Option[
      zio.aws.medialive.model.DvbSubDestinationTeletextGridControl
    ] = None,
    xPosition: Option[__integerMin0] = None,
    yPosition: Option[__integerMin0] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.DvbSubDestinationSettings = {
    import DvbSubDestinationSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.DvbSubDestinationSettings
      .builder()
      .optionallyWith(alignment.map(value => value.unwrap))(_.alignment)
      .optionallyWith(backgroundColor.map(value => value.unwrap))(
        _.backgroundColor
      )
      .optionallyWith(backgroundOpacity.map(value => value: Integer))(
        _.backgroundOpacity
      )
      .optionallyWith(font.map(value => value.buildAwsValue()))(_.font)
      .optionallyWith(fontColor.map(value => value.unwrap))(_.fontColor)
      .optionallyWith(fontOpacity.map(value => value: Integer))(_.fontOpacity)
      .optionallyWith(fontResolution.map(value => value: Integer))(
        _.fontResolution
      )
      .optionallyWith(fontSize.map(value => value: java.lang.String))(
        _.fontSize
      )
      .optionallyWith(outlineColor.map(value => value.unwrap))(_.outlineColor)
      .optionallyWith(outlineSize.map(value => value: Integer))(_.outlineSize)
      .optionallyWith(shadowColor.map(value => value.unwrap))(_.shadowColor)
      .optionallyWith(shadowOpacity.map(value => value: Integer))(
        _.shadowOpacity
      )
      .optionallyWith(shadowXOffset.map(value => value: Integer))(
        _.shadowXOffset
      )
      .optionallyWith(shadowYOffset.map(value => value: Integer))(
        _.shadowYOffset
      )
      .optionallyWith(teletextGridControl.map(value => value.unwrap))(
        _.teletextGridControl
      )
      .optionallyWith(xPosition.map(value => value: Integer))(_.xPosition)
      .optionallyWith(yPosition.map(value => value: Integer))(_.yPosition)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.DvbSubDestinationSettings.ReadOnly =
    zio.aws.medialive.model.DvbSubDestinationSettings.wrap(buildAwsValue())
}
object DvbSubDestinationSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.DvbSubDestinationSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.DvbSubDestinationSettings =
      zio.aws.medialive.model.DvbSubDestinationSettings(
        alignment.map(value => value),
        backgroundColor.map(value => value),
        backgroundOpacity.map(value => value),
        font.map(value => value.asEditable),
        fontColor.map(value => value),
        fontOpacity.map(value => value),
        fontResolution.map(value => value),
        fontSize.map(value => value),
        outlineColor.map(value => value),
        outlineSize.map(value => value),
        shadowColor.map(value => value),
        shadowOpacity.map(value => value),
        shadowXOffset.map(value => value),
        shadowYOffset.map(value => value),
        teletextGridControl.map(value => value),
        xPosition.map(value => value),
        yPosition.map(value => value)
      )
    def alignment: Option[zio.aws.medialive.model.DvbSubDestinationAlignment]
    def backgroundColor
        : Option[zio.aws.medialive.model.DvbSubDestinationBackgroundColor]
    def backgroundOpacity: Option[__integerMin0Max255]
    def font: Option[zio.aws.medialive.model.InputLocation.ReadOnly]
    def fontColor: Option[zio.aws.medialive.model.DvbSubDestinationFontColor]
    def fontOpacity: Option[__integerMin0Max255]
    def fontResolution: Option[__integerMin96Max600]
    def fontSize: Option[__string]
    def outlineColor
        : Option[zio.aws.medialive.model.DvbSubDestinationOutlineColor]
    def outlineSize: Option[__integerMin0Max10]
    def shadowColor
        : Option[zio.aws.medialive.model.DvbSubDestinationShadowColor]
    def shadowOpacity: Option[__integerMin0Max255]
    def shadowXOffset: Option[__integer]
    def shadowYOffset: Option[__integer]
    def teletextGridControl
        : Option[zio.aws.medialive.model.DvbSubDestinationTeletextGridControl]
    def xPosition: Option[__integerMin0]
    def yPosition: Option[__integerMin0]
    def getAlignment: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.DvbSubDestinationAlignment
    ] = AwsError.unwrapOptionField("alignment", alignment)
    def getBackgroundColor: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.DvbSubDestinationBackgroundColor
    ] = AwsError.unwrapOptionField("backgroundColor", backgroundColor)
    def getBackgroundOpacity: ZIO[Any, AwsError, __integerMin0Max255] =
      AwsError.unwrapOptionField("backgroundOpacity", backgroundOpacity)
    def getFont
        : ZIO[Any, AwsError, zio.aws.medialive.model.InputLocation.ReadOnly] =
      AwsError.unwrapOptionField("font", font)
    def getFontColor: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.DvbSubDestinationFontColor
    ] = AwsError.unwrapOptionField("fontColor", fontColor)
    def getFontOpacity: ZIO[Any, AwsError, __integerMin0Max255] =
      AwsError.unwrapOptionField("fontOpacity", fontOpacity)
    def getFontResolution: ZIO[Any, AwsError, __integerMin96Max600] =
      AwsError.unwrapOptionField("fontResolution", fontResolution)
    def getFontSize: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("fontSize", fontSize)
    def getOutlineColor: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.DvbSubDestinationOutlineColor
    ] = AwsError.unwrapOptionField("outlineColor", outlineColor)
    def getOutlineSize: ZIO[Any, AwsError, __integerMin0Max10] =
      AwsError.unwrapOptionField("outlineSize", outlineSize)
    def getShadowColor: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.DvbSubDestinationShadowColor
    ] = AwsError.unwrapOptionField("shadowColor", shadowColor)
    def getShadowOpacity: ZIO[Any, AwsError, __integerMin0Max255] =
      AwsError.unwrapOptionField("shadowOpacity", shadowOpacity)
    def getShadowXOffset: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("shadowXOffset", shadowXOffset)
    def getShadowYOffset: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("shadowYOffset", shadowYOffset)
    def getTeletextGridControl: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.DvbSubDestinationTeletextGridControl
    ] = AwsError.unwrapOptionField("teletextGridControl", teletextGridControl)
    def getXPosition: ZIO[Any, AwsError, __integerMin0] =
      AwsError.unwrapOptionField("xPosition", xPosition)
    def getYPosition: ZIO[Any, AwsError, __integerMin0] =
      AwsError.unwrapOptionField("yPosition", yPosition)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.DvbSubDestinationSettings
  ) extends zio.aws.medialive.model.DvbSubDestinationSettings.ReadOnly {
    override val alignment
        : Option[zio.aws.medialive.model.DvbSubDestinationAlignment] = scala
      .Option(impl.alignment())
      .map(value =>
        zio.aws.medialive.model.DvbSubDestinationAlignment.wrap(value)
      )
    override val backgroundColor
        : Option[zio.aws.medialive.model.DvbSubDestinationBackgroundColor] =
      scala
        .Option(impl.backgroundColor())
        .map(value =>
          zio.aws.medialive.model.DvbSubDestinationBackgroundColor.wrap(value)
        )
    override val backgroundOpacity: Option[__integerMin0Max255] = scala
      .Option(impl.backgroundOpacity())
      .map(value => value: __integerMin0Max255)
    override val font: Option[zio.aws.medialive.model.InputLocation.ReadOnly] =
      scala
        .Option(impl.font())
        .map(value => zio.aws.medialive.model.InputLocation.wrap(value))
    override val fontColor
        : Option[zio.aws.medialive.model.DvbSubDestinationFontColor] = scala
      .Option(impl.fontColor())
      .map(value =>
        zio.aws.medialive.model.DvbSubDestinationFontColor.wrap(value)
      )
    override val fontOpacity: Option[__integerMin0Max255] =
      scala.Option(impl.fontOpacity()).map(value => value: __integerMin0Max255)
    override val fontResolution: Option[__integerMin96Max600] = scala
      .Option(impl.fontResolution())
      .map(value => value: __integerMin96Max600)
    override val fontSize: Option[__string] =
      scala.Option(impl.fontSize()).map(value => value: __string)
    override val outlineColor
        : Option[zio.aws.medialive.model.DvbSubDestinationOutlineColor] = scala
      .Option(impl.outlineColor())
      .map(value =>
        zio.aws.medialive.model.DvbSubDestinationOutlineColor.wrap(value)
      )
    override val outlineSize: Option[__integerMin0Max10] =
      scala.Option(impl.outlineSize()).map(value => value: __integerMin0Max10)
    override val shadowColor
        : Option[zio.aws.medialive.model.DvbSubDestinationShadowColor] = scala
      .Option(impl.shadowColor())
      .map(value =>
        zio.aws.medialive.model.DvbSubDestinationShadowColor.wrap(value)
      )
    override val shadowOpacity: Option[__integerMin0Max255] = scala
      .Option(impl.shadowOpacity())
      .map(value => value: __integerMin0Max255)
    override val shadowXOffset: Option[__integer] =
      scala.Option(impl.shadowXOffset()).map(value => value: __integer)
    override val shadowYOffset: Option[__integer] =
      scala.Option(impl.shadowYOffset()).map(value => value: __integer)
    override val teletextGridControl
        : Option[zio.aws.medialive.model.DvbSubDestinationTeletextGridControl] =
      scala
        .Option(impl.teletextGridControl())
        .map(value =>
          zio.aws.medialive.model.DvbSubDestinationTeletextGridControl
            .wrap(value)
        )
    override val xPosition: Option[__integerMin0] =
      scala.Option(impl.xPosition()).map(value => value: __integerMin0)
    override val yPosition: Option[__integerMin0] =
      scala.Option(impl.yPosition()).map(value => value: __integerMin0)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.DvbSubDestinationSettings
  ): zio.aws.medialive.model.DvbSubDestinationSettings.ReadOnly = new Wrapper(
    impl
  )
}
