package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait DvbSubOcrLanguage {
  def unwrap: software.amazon.awssdk.services.medialive.model.DvbSubOcrLanguage
}
object DvbSubOcrLanguage {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.DvbSubOcrLanguage
  ): zio.aws.medialive.model.DvbSubOcrLanguage = value match {
    case software.amazon.awssdk.services.medialive.model.DvbSubOcrLanguage.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.DvbSubOcrLanguage.DEU =>
      val r = DEU
      r
    case software.amazon.awssdk.services.medialive.model.DvbSubOcrLanguage.ENG =>
      val r = ENG
      r
    case software.amazon.awssdk.services.medialive.model.DvbSubOcrLanguage.FRA =>
      val r = FRA
      r
    case software.amazon.awssdk.services.medialive.model.DvbSubOcrLanguage.NLD =>
      val r = NLD
      r
    case software.amazon.awssdk.services.medialive.model.DvbSubOcrLanguage.POR =>
      val r = POR
      r
    case software.amazon.awssdk.services.medialive.model.DvbSubOcrLanguage.SPA =>
      val r = SPA
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.DvbSubOcrLanguage {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.DvbSubOcrLanguage =
      software.amazon.awssdk.services.medialive.model.DvbSubOcrLanguage.UNKNOWN_TO_SDK_VERSION
  }
  case object DEU extends zio.aws.medialive.model.DvbSubOcrLanguage {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.DvbSubOcrLanguage =
      software.amazon.awssdk.services.medialive.model.DvbSubOcrLanguage.DEU
  }
  case object ENG extends zio.aws.medialive.model.DvbSubOcrLanguage {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.DvbSubOcrLanguage =
      software.amazon.awssdk.services.medialive.model.DvbSubOcrLanguage.ENG
  }
  case object FRA extends zio.aws.medialive.model.DvbSubOcrLanguage {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.DvbSubOcrLanguage =
      software.amazon.awssdk.services.medialive.model.DvbSubOcrLanguage.FRA
  }
  case object NLD extends zio.aws.medialive.model.DvbSubOcrLanguage {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.DvbSubOcrLanguage =
      software.amazon.awssdk.services.medialive.model.DvbSubOcrLanguage.NLD
  }
  case object POR extends zio.aws.medialive.model.DvbSubOcrLanguage {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.DvbSubOcrLanguage =
      software.amazon.awssdk.services.medialive.model.DvbSubOcrLanguage.POR
  }
  case object SPA extends zio.aws.medialive.model.DvbSubOcrLanguage {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.DvbSubOcrLanguage =
      software.amazon.awssdk.services.medialive.model.DvbSubOcrLanguage.SPA
  }
}
