package zio.aws.medialive.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__integerMin1
import scala.jdk.CollectionConverters._
final case class DvbSubSourceSettings(
    ocrLanguage: Option[zio.aws.medialive.model.DvbSubOcrLanguage] = None,
    pid: Option[__integerMin1] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.DvbSubSourceSettings = {
    import DvbSubSourceSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.DvbSubSourceSettings
      .builder()
      .optionallyWith(ocrLanguage.map(value => value.unwrap))(_.ocrLanguage)
      .optionallyWith(pid.map(value => value: Integer))(_.pid)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.DvbSubSourceSettings.ReadOnly =
    zio.aws.medialive.model.DvbSubSourceSettings.wrap(buildAwsValue())
}
object DvbSubSourceSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.DvbSubSourceSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.DvbSubSourceSettings =
      zio.aws.medialive.model.DvbSubSourceSettings(
        ocrLanguage.map(value => value),
        pid.map(value => value)
      )
    def ocrLanguage: Option[zio.aws.medialive.model.DvbSubOcrLanguage]
    def pid: Option[__integerMin1]
    def getOcrLanguage
        : ZIO[Any, AwsError, zio.aws.medialive.model.DvbSubOcrLanguage] =
      AwsError.unwrapOptionField("ocrLanguage", ocrLanguage)
    def getPid: ZIO[Any, AwsError, __integerMin1] =
      AwsError.unwrapOptionField("pid", pid)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.DvbSubSourceSettings
  ) extends zio.aws.medialive.model.DvbSubSourceSettings.ReadOnly {
    override val ocrLanguage
        : Option[zio.aws.medialive.model.DvbSubOcrLanguage] = scala
      .Option(impl.ocrLanguage())
      .map(value => zio.aws.medialive.model.DvbSubOcrLanguage.wrap(value))
    override val pid: Option[__integerMin1] =
      scala.Option(impl.pid()).map(value => value: __integerMin1)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.DvbSubSourceSettings
  ): zio.aws.medialive.model.DvbSubSourceSettings.ReadOnly = new Wrapper(impl)
}
