package zio.aws.medialive.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__integerMin1000Max30000
import scala.jdk.CollectionConverters._
final case class DvbTdtSettings(
    repInterval: Option[__integerMin1000Max30000] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.DvbTdtSettings = {
    import DvbTdtSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.DvbTdtSettings
      .builder()
      .optionallyWith(repInterval.map(value => value: Integer))(_.repInterval)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.DvbTdtSettings.ReadOnly =
    zio.aws.medialive.model.DvbTdtSettings.wrap(buildAwsValue())
}
object DvbTdtSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.DvbTdtSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.DvbTdtSettings =
      zio.aws.medialive.model.DvbTdtSettings(repInterval.map(value => value))
    def repInterval: Option[__integerMin1000Max30000]
    def getRepInterval: ZIO[Any, AwsError, __integerMin1000Max30000] =
      AwsError.unwrapOptionField("repInterval", repInterval)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.DvbTdtSettings
  ) extends zio.aws.medialive.model.DvbTdtSettings.ReadOnly {
    override val repInterval: Option[__integerMin1000Max30000] = scala
      .Option(impl.repInterval())
      .map(value => value: __integerMin1000Max30000)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.DvbTdtSettings
  ): zio.aws.medialive.model.DvbTdtSettings.ReadOnly = new Wrapper(impl)
}
