package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait Eac3BitstreamMode {
  def unwrap: software.amazon.awssdk.services.medialive.model.Eac3BitstreamMode
}
object Eac3BitstreamMode {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.Eac3BitstreamMode
  ): zio.aws.medialive.model.Eac3BitstreamMode = value match {
    case software.amazon.awssdk.services.medialive.model.Eac3BitstreamMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.Eac3BitstreamMode.COMMENTARY =>
      val r = COMMENTARY
      r
    case software.amazon.awssdk.services.medialive.model.Eac3BitstreamMode.COMPLETE_MAIN =>
      val r = COMPLETE_MAIN
      r
    case software.amazon.awssdk.services.medialive.model.Eac3BitstreamMode.EMERGENCY =>
      val r = EMERGENCY
      r
    case software.amazon.awssdk.services.medialive.model.Eac3BitstreamMode.HEARING_IMPAIRED =>
      val r = HEARING_IMPAIRED
      r
    case software.amazon.awssdk.services.medialive.model.Eac3BitstreamMode.VISUALLY_IMPAIRED =>
      val r = VISUALLY_IMPAIRED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.Eac3BitstreamMode {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Eac3BitstreamMode =
      software.amazon.awssdk.services.medialive.model.Eac3BitstreamMode.UNKNOWN_TO_SDK_VERSION
  }
  case object COMMENTARY extends zio.aws.medialive.model.Eac3BitstreamMode {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Eac3BitstreamMode =
      software.amazon.awssdk.services.medialive.model.Eac3BitstreamMode.COMMENTARY
  }
  case object COMPLETE_MAIN extends zio.aws.medialive.model.Eac3BitstreamMode {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Eac3BitstreamMode =
      software.amazon.awssdk.services.medialive.model.Eac3BitstreamMode.COMPLETE_MAIN
  }
  case object EMERGENCY extends zio.aws.medialive.model.Eac3BitstreamMode {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Eac3BitstreamMode =
      software.amazon.awssdk.services.medialive.model.Eac3BitstreamMode.EMERGENCY
  }
  case object HEARING_IMPAIRED
      extends zio.aws.medialive.model.Eac3BitstreamMode {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Eac3BitstreamMode =
      software.amazon.awssdk.services.medialive.model.Eac3BitstreamMode.HEARING_IMPAIRED
  }
  case object VISUALLY_IMPAIRED
      extends zio.aws.medialive.model.Eac3BitstreamMode {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Eac3BitstreamMode =
      software.amazon.awssdk.services.medialive.model.Eac3BitstreamMode.VISUALLY_IMPAIRED
  }
}
