package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait Eac3CodingMode {
  def unwrap: software.amazon.awssdk.services.medialive.model.Eac3CodingMode
}
object Eac3CodingMode {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.Eac3CodingMode
  ): zio.aws.medialive.model.Eac3CodingMode = value match {
    case software.amazon.awssdk.services.medialive.model.Eac3CodingMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.Eac3CodingMode.CODING_MODE_1_0 =>
      val r = CODING_MODE_1_0
      r
    case software.amazon.awssdk.services.medialive.model.Eac3CodingMode.CODING_MODE_2_0 =>
      val r = CODING_MODE_2_0
      r
    case software.amazon.awssdk.services.medialive.model.Eac3CodingMode.CODING_MODE_3_2 =>
      val r = CODING_MODE_3_2
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.Eac3CodingMode {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Eac3CodingMode =
      software.amazon.awssdk.services.medialive.model.Eac3CodingMode.UNKNOWN_TO_SDK_VERSION
  }
  case object CODING_MODE_1_0 extends zio.aws.medialive.model.Eac3CodingMode {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Eac3CodingMode =
      software.amazon.awssdk.services.medialive.model.Eac3CodingMode.CODING_MODE_1_0
  }
  case object CODING_MODE_2_0 extends zio.aws.medialive.model.Eac3CodingMode {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Eac3CodingMode =
      software.amazon.awssdk.services.medialive.model.Eac3CodingMode.CODING_MODE_2_0
  }
  case object CODING_MODE_3_2 extends zio.aws.medialive.model.Eac3CodingMode {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Eac3CodingMode =
      software.amazon.awssdk.services.medialive.model.Eac3CodingMode.CODING_MODE_3_2
  }
}
