package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait Eac3DcFilter {
  def unwrap: software.amazon.awssdk.services.medialive.model.Eac3DcFilter
}
object Eac3DcFilter {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.Eac3DcFilter
  ): zio.aws.medialive.model.Eac3DcFilter = value match {
    case software.amazon.awssdk.services.medialive.model.Eac3DcFilter.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.Eac3DcFilter.DISABLED =>
      val r = DISABLED
      r
    case software.amazon.awssdk.services.medialive.model.Eac3DcFilter.ENABLED =>
      val r = ENABLED
      r
  }
  case object unknownToSdkVersion extends zio.aws.medialive.model.Eac3DcFilter {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Eac3DcFilter =
      software.amazon.awssdk.services.medialive.model.Eac3DcFilter.UNKNOWN_TO_SDK_VERSION
  }
  case object DISABLED extends zio.aws.medialive.model.Eac3DcFilter {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Eac3DcFilter =
      software.amazon.awssdk.services.medialive.model.Eac3DcFilter.DISABLED
  }
  case object ENABLED extends zio.aws.medialive.model.Eac3DcFilter {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Eac3DcFilter =
      software.amazon.awssdk.services.medialive.model.Eac3DcFilter.ENABLED
  }
}
