package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait Eac3DrcLine {
  def unwrap: software.amazon.awssdk.services.medialive.model.Eac3DrcLine
}
object Eac3DrcLine {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.Eac3DrcLine
  ): zio.aws.medialive.model.Eac3DrcLine = value match {
    case software.amazon.awssdk.services.medialive.model.Eac3DrcLine.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.Eac3DrcLine.FILM_LIGHT =>
      val r = FILM_LIGHT
      r
    case software.amazon.awssdk.services.medialive.model.Eac3DrcLine.FILM_STANDARD =>
      val r = FILM_STANDARD
      r
    case software.amazon.awssdk.services.medialive.model.Eac3DrcLine.MUSIC_LIGHT =>
      val r = MUSIC_LIGHT
      r
    case software.amazon.awssdk.services.medialive.model.Eac3DrcLine.MUSIC_STANDARD =>
      val r = MUSIC_STANDARD
      r
    case software.amazon.awssdk.services.medialive.model.Eac3DrcLine.NONE =>
      val r = NONE
      r
    case software.amazon.awssdk.services.medialive.model.Eac3DrcLine.SPEECH =>
      val r = SPEECH
      r
  }
  case object unknownToSdkVersion extends zio.aws.medialive.model.Eac3DrcLine {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Eac3DrcLine =
      software.amazon.awssdk.services.medialive.model.Eac3DrcLine.UNKNOWN_TO_SDK_VERSION
  }
  case object FILM_LIGHT extends zio.aws.medialive.model.Eac3DrcLine {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Eac3DrcLine =
      software.amazon.awssdk.services.medialive.model.Eac3DrcLine.FILM_LIGHT
  }
  case object FILM_STANDARD extends zio.aws.medialive.model.Eac3DrcLine {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Eac3DrcLine =
      software.amazon.awssdk.services.medialive.model.Eac3DrcLine.FILM_STANDARD
  }
  case object MUSIC_LIGHT extends zio.aws.medialive.model.Eac3DrcLine {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Eac3DrcLine =
      software.amazon.awssdk.services.medialive.model.Eac3DrcLine.MUSIC_LIGHT
  }
  case object MUSIC_STANDARD extends zio.aws.medialive.model.Eac3DrcLine {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Eac3DrcLine =
      software.amazon.awssdk.services.medialive.model.Eac3DrcLine.MUSIC_STANDARD
  }
  case object NONE extends zio.aws.medialive.model.Eac3DrcLine {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Eac3DrcLine =
      software.amazon.awssdk.services.medialive.model.Eac3DrcLine.NONE
  }
  case object SPEECH extends zio.aws.medialive.model.Eac3DrcLine {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Eac3DrcLine =
      software.amazon.awssdk.services.medialive.model.Eac3DrcLine.SPEECH
  }
}
