package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait Eac3LfeControl {
  def unwrap: software.amazon.awssdk.services.medialive.model.Eac3LfeControl
}
object Eac3LfeControl {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.Eac3LfeControl
  ): zio.aws.medialive.model.Eac3LfeControl = value match {
    case software.amazon.awssdk.services.medialive.model.Eac3LfeControl.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.Eac3LfeControl.LFE =>
      val r = LFE
      r
    case software.amazon.awssdk.services.medialive.model.Eac3LfeControl.NO_LFE =>
      val r = NO_LFE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.Eac3LfeControl {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Eac3LfeControl =
      software.amazon.awssdk.services.medialive.model.Eac3LfeControl.UNKNOWN_TO_SDK_VERSION
  }
  case object LFE extends zio.aws.medialive.model.Eac3LfeControl {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Eac3LfeControl =
      software.amazon.awssdk.services.medialive.model.Eac3LfeControl.LFE
  }
  case object NO_LFE extends zio.aws.medialive.model.Eac3LfeControl {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Eac3LfeControl =
      software.amazon.awssdk.services.medialive.model.Eac3LfeControl.NO_LFE
  }
}
