package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait Eac3LfeFilter {
  def unwrap: software.amazon.awssdk.services.medialive.model.Eac3LfeFilter
}
object Eac3LfeFilter {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.Eac3LfeFilter
  ): zio.aws.medialive.model.Eac3LfeFilter = value match {
    case software.amazon.awssdk.services.medialive.model.Eac3LfeFilter.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.Eac3LfeFilter.DISABLED =>
      val r = DISABLED
      r
    case software.amazon.awssdk.services.medialive.model.Eac3LfeFilter.ENABLED =>
      val r = ENABLED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.Eac3LfeFilter {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Eac3LfeFilter =
      software.amazon.awssdk.services.medialive.model.Eac3LfeFilter.UNKNOWN_TO_SDK_VERSION
  }
  case object DISABLED extends zio.aws.medialive.model.Eac3LfeFilter {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Eac3LfeFilter =
      software.amazon.awssdk.services.medialive.model.Eac3LfeFilter.DISABLED
  }
  case object ENABLED extends zio.aws.medialive.model.Eac3LfeFilter {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Eac3LfeFilter =
      software.amazon.awssdk.services.medialive.model.Eac3LfeFilter.ENABLED
  }
}
