package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait Eac3PassthroughControl {
  def unwrap
      : software.amazon.awssdk.services.medialive.model.Eac3PassthroughControl
}
object Eac3PassthroughControl {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.Eac3PassthroughControl
  ): zio.aws.medialive.model.Eac3PassthroughControl = value match {
    case software.amazon.awssdk.services.medialive.model.Eac3PassthroughControl.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.Eac3PassthroughControl.NO_PASSTHROUGH =>
      val r = NO_PASSTHROUGH
      r
    case software.amazon.awssdk.services.medialive.model.Eac3PassthroughControl.WHEN_POSSIBLE =>
      val r = WHEN_POSSIBLE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.Eac3PassthroughControl {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Eac3PassthroughControl =
      software.amazon.awssdk.services.medialive.model.Eac3PassthroughControl.UNKNOWN_TO_SDK_VERSION
  }
  case object NO_PASSTHROUGH
      extends zio.aws.medialive.model.Eac3PassthroughControl {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Eac3PassthroughControl =
      software.amazon.awssdk.services.medialive.model.Eac3PassthroughControl.NO_PASSTHROUGH
  }
  case object WHEN_POSSIBLE
      extends zio.aws.medialive.model.Eac3PassthroughControl {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Eac3PassthroughControl =
      software.amazon.awssdk.services.medialive.model.Eac3PassthroughControl.WHEN_POSSIBLE
  }
}
